/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.EventGDTLogger;
import com.google.firebase.sessions.EventGDTLogger_Factory;
import com.google.firebase.sessions.FirebaseSessions;
import com.google.firebase.sessions.FirebaseSessionsComponent;
import com.google.firebase.sessions.FirebaseSessionsComponent_MainModule_Companion_SessionGeneratorFactory;
import com.google.firebase.sessions.FirebaseSessions_Factory;
import com.google.firebase.sessions.SessionDatastore;
import com.google.firebase.sessions.SessionDatastoreImpl;
import com.google.firebase.sessions.SessionDatastoreImpl_Factory;
import com.google.firebase.sessions.SessionFirelogPublisher;
import com.google.firebase.sessions.SessionFirelogPublisherImpl;
import com.google.firebase.sessions.SessionFirelogPublisherImpl_Factory;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.SessionLifecycleServiceBinderImpl;
import com.google.firebase.sessions.SessionLifecycleServiceBinderImpl_Factory;
import com.google.firebase.sessions.dagger.internal.DaggerGenerated;
import com.google.firebase.sessions.dagger.internal.DoubleCheck;
import com.google.firebase.sessions.dagger.internal.InstanceFactory;
import com.google.firebase.sessions.dagger.internal.Preconditions;
import com.google.firebase.sessions.settings.SessionsSettings;
import com.google.firebase.sessions.settings.SessionsSettings_Factory;
import kotlin.coroutines.CoroutineContext;

@DaggerGenerated
public final class DaggerFirebaseSessionsComponent {
    private DaggerFirebaseSessionsComponent() {
    }

    public static FirebaseSessionsComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements FirebaseSessionsComponent.Builder {
        private Context appContext;
        private CoroutineContext backgroundDispatcher;
        private CoroutineContext blockingDispatcher;
        private FirebaseApp firebaseApp;
        private FirebaseInstallationsApi firebaseInstallationsApi;
        private Provider<TransportFactory> transportFactoryProvider;

        private Builder() {
        }

        @Override
        public Builder appContext(Context appContext) {
            this.appContext = Preconditions.checkNotNull(appContext);
            return this;
        }

        @Override
        public Builder backgroundDispatcher(CoroutineContext backgroundDispatcher) {
            this.backgroundDispatcher = Preconditions.checkNotNull(backgroundDispatcher);
            return this;
        }

        @Override
        public Builder blockingDispatcher(CoroutineContext blockingDispatcher) {
            this.blockingDispatcher = Preconditions.checkNotNull(blockingDispatcher);
            return this;
        }

        @Override
        public Builder firebaseApp(FirebaseApp firebaseApp) {
            this.firebaseApp = Preconditions.checkNotNull(firebaseApp);
            return this;
        }

        @Override
        public Builder firebaseInstallationsApi(FirebaseInstallationsApi firebaseInstallationsApi) {
            this.firebaseInstallationsApi = Preconditions.checkNotNull(firebaseInstallationsApi);
            return this;
        }

        @Override
        public Builder transportFactoryProvider(Provider<TransportFactory> transportFactoryProvider) {
            this.transportFactoryProvider = Preconditions.checkNotNull(transportFactoryProvider);
            return this;
        }

        @Override
        public FirebaseSessionsComponent build() {
            Preconditions.checkBuilderRequirement(this.appContext, Context.class);
            Preconditions.checkBuilderRequirement(this.backgroundDispatcher, CoroutineContext.class);
            Preconditions.checkBuilderRequirement(this.blockingDispatcher, CoroutineContext.class);
            Preconditions.checkBuilderRequirement(this.firebaseApp, FirebaseApp.class);
            Preconditions.checkBuilderRequirement(this.firebaseInstallationsApi, FirebaseInstallationsApi.class);
            Preconditions.checkBuilderRequirement(this.transportFactoryProvider, Provider.class);
            return new FirebaseSessionsComponentImpl(this.appContext, this.backgroundDispatcher, this.blockingDispatcher, this.firebaseApp, this.firebaseInstallationsApi, this.transportFactoryProvider);
        }
    }

    private static final class FirebaseSessionsComponentImpl
    implements FirebaseSessionsComponent {
        private final FirebaseSessionsComponentImpl firebaseSessionsComponentImpl = this;
        private javax.inject.Provider<FirebaseApp> firebaseAppProvider;
        private javax.inject.Provider<CoroutineContext> blockingDispatcherProvider;
        private javax.inject.Provider<CoroutineContext> backgroundDispatcherProvider;
        private javax.inject.Provider<FirebaseInstallationsApi> firebaseInstallationsApiProvider;
        private javax.inject.Provider<SessionsSettings> sessionsSettingsProvider;
        private javax.inject.Provider<Context> appContextProvider;
        private javax.inject.Provider<SessionLifecycleServiceBinderImpl> sessionLifecycleServiceBinderImplProvider;
        private javax.inject.Provider<FirebaseSessions> firebaseSessionsProvider;
        private javax.inject.Provider<SessionDatastoreImpl> sessionDatastoreImplProvider;
        private javax.inject.Provider<Provider<TransportFactory>> transportFactoryProvider;
        private javax.inject.Provider<EventGDTLogger> eventGDTLoggerProvider;
        private javax.inject.Provider<SessionFirelogPublisherImpl> sessionFirelogPublisherImplProvider;
        private javax.inject.Provider<SessionGenerator> sessionGeneratorProvider;

        private FirebaseSessionsComponentImpl(Context appContextParam, CoroutineContext backgroundDispatcherParam, CoroutineContext blockingDispatcherParam, FirebaseApp firebaseAppParam, FirebaseInstallationsApi firebaseInstallationsApiParam, Provider<TransportFactory> transportFactoryProviderParam) {
            this.initialize(appContextParam, backgroundDispatcherParam, blockingDispatcherParam, firebaseAppParam, firebaseInstallationsApiParam, transportFactoryProviderParam);
        }

        private void initialize(Context appContextParam, CoroutineContext backgroundDispatcherParam, CoroutineContext blockingDispatcherParam, FirebaseApp firebaseAppParam, FirebaseInstallationsApi firebaseInstallationsApiParam, Provider<TransportFactory> transportFactoryProviderParam) {
            this.firebaseAppProvider = InstanceFactory.create(firebaseAppParam);
            this.blockingDispatcherProvider = InstanceFactory.create(blockingDispatcherParam);
            this.backgroundDispatcherProvider = InstanceFactory.create(backgroundDispatcherParam);
            this.firebaseInstallationsApiProvider = InstanceFactory.create(firebaseInstallationsApiParam);
            this.sessionsSettingsProvider = DoubleCheck.provider(SessionsSettings_Factory.create(this.firebaseAppProvider, this.blockingDispatcherProvider, this.backgroundDispatcherProvider, this.firebaseInstallationsApiProvider));
            this.appContextProvider = InstanceFactory.create(appContextParam);
            this.sessionLifecycleServiceBinderImplProvider = DoubleCheck.provider(SessionLifecycleServiceBinderImpl_Factory.create(this.appContextProvider));
            this.firebaseSessionsProvider = DoubleCheck.provider(FirebaseSessions_Factory.create(this.firebaseAppProvider, this.sessionsSettingsProvider, this.backgroundDispatcherProvider, this.sessionLifecycleServiceBinderImplProvider));
            this.sessionDatastoreImplProvider = DoubleCheck.provider(SessionDatastoreImpl_Factory.create(this.appContextProvider, this.backgroundDispatcherProvider));
            this.transportFactoryProvider = InstanceFactory.create(transportFactoryProviderParam);
            this.eventGDTLoggerProvider = DoubleCheck.provider(EventGDTLogger_Factory.create(this.transportFactoryProvider));
            this.sessionFirelogPublisherImplProvider = DoubleCheck.provider(SessionFirelogPublisherImpl_Factory.create(this.firebaseAppProvider, this.firebaseInstallationsApiProvider, this.sessionsSettingsProvider, this.eventGDTLoggerProvider, this.backgroundDispatcherProvider));
            this.sessionGeneratorProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_SessionGeneratorFactory.create());
        }

        @Override
        public FirebaseSessions getFirebaseSessions() {
            return (FirebaseSessions)this.firebaseSessionsProvider.get();
        }

        @Override
        public SessionDatastore getSessionDatastore() {
            return (SessionDatastore)this.sessionDatastoreImplProvider.get();
        }

        @Override
        public SessionFirelogPublisher getSessionFirelogPublisher() {
            return (SessionFirelogPublisher)this.sessionFirelogPublisherImplProvider.get();
        }

        @Override
        public SessionGenerator getSessionGenerator() {
            return (SessionGenerator)this.sessionGeneratorProvider.get();
        }

        @Override
        public SessionsSettings getSessionsSettings() {
            return (SessionsSettings)this.sessionsSettingsProvider.get();
        }
    }
}

