/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.datastore.DataStoreFile;
import androidx.datastore.core.CorruptionException;
import androidx.datastore.core.DataMigration;
import androidx.datastore.core.DataStore;
import androidx.datastore.core.DataStoreFactory;
import androidx.datastore.core.MultiProcessDataStoreFactory;
import androidx.datastore.core.Serializer;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.ApplicationInfo;
import com.google.firebase.sessions.EventGDTLogger;
import com.google.firebase.sessions.EventGDTLoggerInterface;
import com.google.firebase.sessions.FirebaseSessions;
import com.google.firebase.sessions.LocalOverrideSettingsProvider;
import com.google.firebase.sessions.ProcessDataManager;
import com.google.firebase.sessions.ProcessDataManagerImpl;
import com.google.firebase.sessions.RemoteSettingsProvider;
import com.google.firebase.sessions.SessionData;
import com.google.firebase.sessions.SessionDataSerializer;
import com.google.firebase.sessions.SessionEvents;
import com.google.firebase.sessions.SessionFirelogPublisher;
import com.google.firebase.sessions.SessionFirelogPublisherImpl;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.SharedSessionRepository;
import com.google.firebase.sessions.SharedSessionRepositoryImpl;
import com.google.firebase.sessions.TimeProvider;
import com.google.firebase.sessions.TimeProviderImpl;
import com.google.firebase.sessions.UuidGenerator;
import com.google.firebase.sessions.UuidGeneratorImpl;
import com.google.firebase.sessions.dagger.Binds;
import com.google.firebase.sessions.dagger.BindsInstance;
import com.google.firebase.sessions.dagger.Component;
import com.google.firebase.sessions.dagger.Module;
import com.google.firebase.sessions.dagger.Provides;
import com.google.firebase.sessions.settings.CrashlyticsSettingsFetcher;
import com.google.firebase.sessions.settings.LocalOverrideSettings;
import com.google.firebase.sessions.settings.RemoteSettings;
import com.google.firebase.sessions.settings.RemoteSettingsFetcher;
import com.google.firebase.sessions.settings.SessionConfigs;
import com.google.firebase.sessions.settings.SessionConfigsSerializer;
import com.google.firebase.sessions.settings.SessionsSettings;
import com.google.firebase.sessions.settings.SettingsCache;
import com.google.firebase.sessions.settings.SettingsCacheImpl;
import com.google.firebase.sessions.settings.SettingsProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Component(modules={MainModule.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\ba\u0018\u00002\u00020\u0001:\u0002\u0016\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsComponent;", "", "firebaseSessions", "Lcom/google/firebase/sessions/FirebaseSessions;", "getFirebaseSessions", "()Lcom/google/firebase/sessions/FirebaseSessions;", "sessionFirelogPublisher", "Lcom/google/firebase/sessions/SessionFirelogPublisher;", "getSessionFirelogPublisher", "()Lcom/google/firebase/sessions/SessionFirelogPublisher;", "sessionGenerator", "Lcom/google/firebase/sessions/SessionGenerator;", "getSessionGenerator", "()Lcom/google/firebase/sessions/SessionGenerator;", "sessionsSettings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "getSessionsSettings", "()Lcom/google/firebase/sessions/settings/SessionsSettings;", "sharedSessionRepository", "Lcom/google/firebase/sessions/SharedSessionRepository;", "getSharedSessionRepository", "()Lcom/google/firebase/sessions/SharedSessionRepository;", "Builder", "MainModule", "com.google.firebase-firebase-sessions"})
public interface FirebaseSessionsComponent {
    @NotNull
    public FirebaseSessions getFirebaseSessions();

    @NotNull
    public SessionFirelogPublisher getSessionFirelogPublisher();

    @NotNull
    public SessionGenerator getSessionGenerator();

    @NotNull
    public SessionsSettings getSessionsSettings();

    @NotNull
    public SharedSessionRepository getSharedSessionRepository();

    @Component.Builder
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H'J\u0012\u0010\u0004\u001a\u00020\u00002\b\b\u0001\u0010\u0004\u001a\u00020\u0005H'J\u0012\u0010\u0006\u001a\u00020\u00002\b\b\u0001\u0010\u0006\u001a\u00020\u0005H'J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH'J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH'J\u0016\u0010\u000b\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH'J\b\u0010\u000e\u001a\u00020\u000fH&\u00a8\u0006\u0010"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsComponent$Builder;", "", "appContext", "Landroid/content/Context;", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "blockingDispatcher", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "firebaseInstallationsApi", "Lcom/google/firebase/installations/FirebaseInstallationsApi;", "transportFactoryProvider", "Lcom/google/firebase/inject/Provider;", "Lcom/google/android/datatransport/TransportFactory;", "build", "Lcom/google/firebase/sessions/FirebaseSessionsComponent;", "com.google.firebase-firebase-sessions"})
    public static interface Builder {
        @BindsInstance
        @NotNull
        public Builder appContext(@NotNull Context var1);

        @BindsInstance
        @NotNull
        public Builder backgroundDispatcher(@Background @NotNull CoroutineContext var1);

        @BindsInstance
        @NotNull
        public Builder blockingDispatcher(@Blocking @NotNull CoroutineContext var1);

        @BindsInstance
        @NotNull
        public Builder firebaseApp(@NotNull FirebaseApp var1);

        @BindsInstance
        @NotNull
        public Builder firebaseInstallationsApi(@NotNull FirebaseInstallationsApi var1);

        @BindsInstance
        @NotNull
        public Builder transportFactoryProvider(@NotNull Provider<TransportFactory> var1);

        @NotNull
        public FirebaseSessionsComponent build();
    }

    @Module
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\bH'J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u000bH'J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u000eH'J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0010H'J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0013H'J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0016H'J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0019H'\u00a8\u0006\u001b"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsComponent$MainModule;", "", "eventGDTLoggerInterface", "Lcom/google/firebase/sessions/EventGDTLoggerInterface;", "impl", "Lcom/google/firebase/sessions/EventGDTLogger;", "sessionFirelogPublisher", "Lcom/google/firebase/sessions/SessionFirelogPublisher;", "Lcom/google/firebase/sessions/SessionFirelogPublisherImpl;", "crashlyticsSettingsFetcher", "Lcom/google/firebase/sessions/settings/CrashlyticsSettingsFetcher;", "Lcom/google/firebase/sessions/settings/RemoteSettingsFetcher;", "localOverrideSettings", "Lcom/google/firebase/sessions/settings/SettingsProvider;", "Lcom/google/firebase/sessions/settings/LocalOverrideSettings;", "remoteSettings", "Lcom/google/firebase/sessions/settings/RemoteSettings;", "settingsCache", "Lcom/google/firebase/sessions/settings/SettingsCache;", "Lcom/google/firebase/sessions/settings/SettingsCacheImpl;", "sharedSessionRepository", "Lcom/google/firebase/sessions/SharedSessionRepository;", "Lcom/google/firebase/sessions/SharedSessionRepositoryImpl;", "processDataManager", "Lcom/google/firebase/sessions/ProcessDataManager;", "Lcom/google/firebase/sessions/ProcessDataManagerImpl;", "Companion", "com.google.firebase-firebase-sessions"})
    public static interface MainModule {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Binds
        @Singleton
        @NotNull
        public EventGDTLoggerInterface eventGDTLoggerInterface(@NotNull EventGDTLogger var1);

        @Binds
        @Singleton
        @NotNull
        public SessionFirelogPublisher sessionFirelogPublisher(@NotNull SessionFirelogPublisherImpl var1);

        @Binds
        @Singleton
        @NotNull
        public CrashlyticsSettingsFetcher crashlyticsSettingsFetcher(@NotNull RemoteSettingsFetcher var1);

        @Binds
        @Singleton
        @LocalOverrideSettingsProvider
        @NotNull
        public SettingsProvider localOverrideSettings(@NotNull LocalOverrideSettings var1);

        @Binds
        @Singleton
        @RemoteSettingsProvider
        @NotNull
        public SettingsProvider remoteSettings(@NotNull RemoteSettings var1);

        @Binds
        @Singleton
        @NotNull
        public SettingsCache settingsCache(@NotNull SettingsCacheImpl var1);

        @Binds
        @Singleton
        @NotNull
        public SharedSessionRepository sharedSessionRepository(@NotNull SharedSessionRepositoryImpl var1);

        @Binds
        @Singleton
        @NotNull
        public ProcessDataManager processDataManager(@NotNull ProcessDataManagerImpl var1);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\\\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\r\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020$H\u0002\u00a8\u0006*"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsComponent$MainModule$Companion;", "", "<init>", "()V", "timeProvider", "Lcom/google/firebase/sessions/TimeProvider;", "uuidGenerator", "Lcom/google/firebase/sessions/UuidGenerator;", "applicationInfo", "Lcom/google/firebase/sessions/ApplicationInfo;", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "sessionConfigsDataStore", "Landroidx/datastore/core/DataStore;", "Lcom/google/firebase/sessions/settings/SessionConfigs;", "appContext", "Landroid/content/Context;", "blockingDispatcher", "Lkotlin/coroutines/CoroutineContext;", "sessionDataStore", "Lcom/google/firebase/sessions/SessionData;", "sessionDataSerializer", "Lcom/google/firebase/sessions/SessionDataSerializer;", "createDataStore", "T", "serializer", "Landroidx/datastore/core/Serializer;", "corruptionHandler", "Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;", "migrations", "", "Landroidx/datastore/core/DataMigration;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "produceFile", "Lkotlin/Function0;", "Ljava/io/File;", "loadDataStoreSharedCounter", "", "prepDataStoreFile", "", "dataStoreFile", "com.google.firebase-firebase-sessions"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @Provides
            @Singleton
            @NotNull
            public final TimeProvider timeProvider() {
                return TimeProviderImpl.INSTANCE;
            }

            @Provides
            @Singleton
            @NotNull
            public final UuidGenerator uuidGenerator() {
                return UuidGeneratorImpl.INSTANCE;
            }

            @Provides
            @Singleton
            @NotNull
            public final ApplicationInfo applicationInfo(@NotNull FirebaseApp firebaseApp) {
                Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
                return SessionEvents.INSTANCE.getApplicationInfo(firebaseApp);
            }

            @Provides
            @Singleton
            @NotNull
            public final DataStore<SessionConfigs> sessionConfigsDataStore(@NotNull Context appContext, @Blocking @NotNull CoroutineContext blockingDispatcher) {
                Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
                Intrinsics.checkNotNullParameter((Object)blockingDispatcher, (String)"blockingDispatcher");
                return com.google.firebase.sessions.FirebaseSessionsComponent$MainModule$Companion.createDataStore$default(this, SessionConfigsSerializer.INSTANCE, new ReplaceFileCorruptionHandler(Companion::sessionConfigsDataStore$lambda$0), null, CoroutineScopeKt.CoroutineScope((CoroutineContext)blockingDispatcher), () -> Companion.sessionConfigsDataStore$lambda$2(appContext), 4, null);
            }

            @Provides
            @Singleton
            @NotNull
            public final DataStore<SessionData> sessionDataStore(@NotNull Context appContext, @Blocking @NotNull CoroutineContext blockingDispatcher, @NotNull SessionDataSerializer sessionDataSerializer) {
                Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
                Intrinsics.checkNotNullParameter((Object)blockingDispatcher, (String)"blockingDispatcher");
                Intrinsics.checkNotNullParameter((Object)sessionDataSerializer, (String)"sessionDataSerializer");
                return com.google.firebase.sessions.FirebaseSessionsComponent$MainModule$Companion.createDataStore$default(this, sessionDataSerializer, new ReplaceFileCorruptionHandler(arg_0 -> Companion.sessionDataStore$lambda$3(sessionDataSerializer, arg_0)), null, CoroutineScopeKt.CoroutineScope((CoroutineContext)blockingDispatcher), () -> Companion.sessionDataStore$lambda$5(appContext), 4, null);
            }

            private final <T> DataStore<T> createDataStore(Serializer<T> serializer2, ReplaceFileCorruptionHandler<T> corruptionHandler, List<? extends DataMigration<T>> migrations, CoroutineScope scope, Function0<? extends File> produceFile) {
                return this.loadDataStoreSharedCounter() ? MultiProcessDataStoreFactory.INSTANCE.create(serializer2, corruptionHandler, migrations, scope, produceFile) : DataStoreFactory.INSTANCE.create(serializer2, corruptionHandler, migrations, scope, produceFile);
            }

            static /* synthetic */ DataStore createDataStore$default(Companion companion, Serializer serializer2, ReplaceFileCorruptionHandler replaceFileCorruptionHandler, List list, CoroutineScope coroutineScope, Function0 function0, int n, Object object) {
                if ((n & 4) != 0) {
                    list = CollectionsKt.emptyList();
                }
                return companion.createDataStore(serializer2, replaceFileCorruptionHandler, list, coroutineScope, (Function0<? extends File>)function0);
            }

            private final boolean loadDataStoreSharedCounter() {
                boolean bl;
                try {
                    System.loadLibrary("datastore_shared_counter");
                    bl = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    bl = false;
                }
                catch (SecurityException securityException) {
                    bl = false;
                }
                return bl;
            }

            private final void prepDataStoreFile(File dataStoreFile) {
                File file = dataStoreFile.getParentFile();
                if (file == null) {
                    return;
                }
                File parentDir = file;
                if (parentDir.exists() && !parentDir.isDirectory() && Intrinsics.areEqual((Object)parentDir.getName(), (Object)"firebaseSessions") && !parentDir.delete()) {
                    throw new IOException("Failed to delete conflicting file: " + parentDir);
                }
                if (parentDir.isDirectory()) {
                    return;
                }
                if (Build.VERSION.SDK_INT >= 26) {
                    try {
                        Path path = Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
                    }
                    catch (Exception ex) {
                        throw new IOException("Failed to create directory: " + parentDir, ex);
                    }
                } else if (!parentDir.mkdirs() && !parentDir.isDirectory()) {
                    throw new IOException("Failed to create directory: " + parentDir);
                }
            }

            private static final SessionConfigs sessionConfigsDataStore$lambda$0(CorruptionException ex) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                Log.w((String)"FirebaseSessions", (String)"CorruptionException in session configs DataStore", (Throwable)((Throwable)ex));
                return SessionConfigsSerializer.INSTANCE.getDefaultValue();
            }

            private static final File sessionConfigsDataStore$lambda$2(Context $appContext) {
                File file;
                File it = file = DataStoreFile.dataStoreFile((Context)$appContext, (String)"firebaseSessions/sessionConfigsDataStore.data");
                boolean bl = false;
                $$INSTANCE.prepDataStoreFile(it);
                return file;
            }

            private static final SessionData sessionDataStore$lambda$3(SessionDataSerializer $sessionDataSerializer, CorruptionException ex) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                Log.w((String)"FirebaseSessions", (String)"CorruptionException in session data DataStore", (Throwable)((Throwable)ex));
                return $sessionDataSerializer.getDefaultValue();
            }

            private static final File sessionDataStore$lambda$5(Context $appContext) {
                File file;
                File it = file = DataStoreFile.dataStoreFile((Context)$appContext, (String)"firebaseSessions/sessionDataStore.data");
                boolean bl = false;
                $$INSTANCE.prepDataStoreFile(it);
                return file;
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

