/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzc;
import com.google.firebase.storage.zze;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zzcnl = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzcnm = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    final zze<OnSuccessListener<? super TResult>, TResult> zzcnn = new zze(this, 128, new zze.zza<OnSuccessListener<? super TResult>, TResult>(){

        public void zza(@NonNull OnSuccessListener<? super TResult> onSuccessListener, @NonNull TResult TResult) {
            zzc.zzacF().zzc(StorageTask.this);
            onSuccessListener.onSuccess(TResult);
        }

        @Override
        public /* synthetic */ void zzk(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnSuccessListener)object, (ProvideError)object2);
        }
    });
    @VisibleForTesting
    final zze<OnFailureListener, TResult> zzcno = new zze(this, 320, new zze.zza<OnFailureListener, TResult>(){

        public void zza(@NonNull OnFailureListener onFailureListener, @NonNull TResult TResult) {
            zzc.zzacF().zzc(StorageTask.this);
            onFailureListener.onFailure(TResult.getError());
        }

        @Override
        public /* synthetic */ void zzk(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnFailureListener)object, (ProvideError)object2);
        }
    });
    @VisibleForTesting
    final zze<OnCompleteListener<TResult>, TResult> zzcnp = new zze(this, 448, new zze.zza<OnCompleteListener<TResult>, TResult>(){

        public void zza(@NonNull OnCompleteListener<TResult> onCompleteListener, @NonNull TResult TResult) {
            zzc.zzacF().zzc(StorageTask.this);
            onCompleteListener.onComplete((Task)StorageTask.this);
        }

        @Override
        public /* synthetic */ void zzk(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnCompleteListener)object, (ProvideError)object2);
        }
    });
    @VisibleForTesting
    final zze<OnProgressListener<? super TResult>, TResult> zzcnq = new zze(this, -465, new zze.zza<OnProgressListener<? super TResult>, TResult>(this){

        public void zza(@NonNull OnProgressListener<? super TResult> onProgressListener, @NonNull TResult TResult) {
            onProgressListener.onProgress(TResult);
        }

        @Override
        public /* synthetic */ void zzk(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnProgressListener)object, (ProvideError)object2);
        }
    });
    @VisibleForTesting
    final zze<OnPausedListener<? super TResult>, TResult> zzcnr = new zze(this, 16, new zze.zza<OnPausedListener<? super TResult>, TResult>(this){

        public void zza(@NonNull OnPausedListener<? super TResult> onPausedListener, @NonNull TResult TResult) {
            onPausedListener.onPaused(TResult);
        }

        @Override
        public /* synthetic */ void zzk(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnPausedListener)object, (ProvideError)object2);
        }
    });
    private volatile int zzMN = 1;
    private TResult zzcns;

    protected StorageTask() {
    }

    @VisibleForTesting
    boolean zzacz() {
        if (this.zzf(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzf(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zzf(16, true) || this.zzf(8, true);
    }

    @Override
    public boolean cancel() {
        return this.zzf(256, true) || this.zzf(32, true);
    }

    public boolean isComplete() {
        return (this.zzacA() & 0x80) != 0 || (this.zzacA() & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzacA() & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzacA() == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzacA() & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzacA() & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzacD() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzacD().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzacD();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzacD() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzacD().getError())) {
            throw (Throwable)clazz.cast(this.zzacD().getError());
        }
        Exception exception = this.zzacD().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzacD();
    }

    @Nullable
    public Exception getException() {
        if (this.zzacD() == null) {
            return null;
        }
        return this.zzacD().getError();
    }

    public TResult getSnapshot() {
        return this.zzacC();
    }

    @VisibleForTesting
    int zzacA() {
        return this.zzMN;
    }

    @VisibleForTesting
    Object zzacB() {
        return this.mSyncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    TResult zzacC() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzacu();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzacu();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean zzf(int n, boolean bl) {
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2;
            Object object3;
            if (Log.isLoggable((String)"StorageTask", (int)3)) {
                object3 = String.valueOf(this.zzqM(n));
                object2 = String.valueOf(this.zzqM(this.zzMN));
                Log.d((String)"StorageTask", (String)new StringBuilder(54 + String.valueOf(object3).length() + String.valueOf(object2).length()).append("changing internal state to: ").append((String)object3).append(" isUser: ").append(bl).append(" from state:").append((String)object2).toString());
            }
            if ((object2 = ((HashMap)(object3 = bl ? zzcnl : zzcnm)).get(this.zzacA())) != null && ((HashSet)object2).contains(n)) {
                this.zzMN = n;
                switch (this.zzMN) {
                    case 2: {
                        zzc.zzacF().zzb(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzcnn.zzacM();
                this.zzcno.zzacM();
                this.zzcnp.zzacM();
                this.zzcnr.zzacM();
                this.zzcnq.zzacM();
                return true;
            }
            String string = String.valueOf(this.zzqM(n));
            String string2 = String.valueOf(this.zzqM(this.zzMN));
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string2).length()).append("unable to change internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
            return false;
        }
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private TResult zzacD() {
        if (this.zzcns != null) {
            return this.zzcns;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzcns == null) {
            this.zzcns = this.zzacC();
        }
        return this.zzcns;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzac.zzw(onPausedListener);
        this.zzcnr.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzac.zzw(onPausedListener);
        zzac.zzw((Object)executor);
        this.zzcnr.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzac.zzw(onPausedListener);
        zzac.zzw((Object)activity);
        this.zzcnr.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzac.zzw(onPausedListener);
        this.zzcnr.zzaJ(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzac.zzw(onProgressListener);
        this.zzcnq.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzac.zzw(onProgressListener);
        zzac.zzw((Object)executor);
        this.zzcnq.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzac.zzw(onProgressListener);
        zzac.zzw((Object)activity);
        this.zzcnq.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzac.zzw(onProgressListener);
        this.zzcnq.zzaJ(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzac.zzw(onSuccessListener);
        this.zzcnn.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzac.zzw((Object)executor);
        zzac.zzw(onSuccessListener);
        this.zzcnn.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzac.zzw((Object)activity);
        zzac.zzw(onSuccessListener);
        this.zzcnn.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzac.zzw(onSuccessListener);
        this.zzcnn.zzaJ(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzac.zzw((Object)onFailureListener);
        this.zzcno.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzac.zzw((Object)onFailureListener);
        zzac.zzw((Object)executor);
        this.zzcno.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzac.zzw((Object)onFailureListener);
        zzac.zzw((Object)activity);
        this.zzcno.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzac.zzw((Object)onFailureListener);
        this.zzcno.zzaJ(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzac.zzw(onCompleteListener);
        this.zzcnp.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzac.zzw(onCompleteListener);
        zzac.zzw((Object)executor);
        this.zzcnp.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzac.zzw(onCompleteListener);
        zzac.zzw((Object)activity);
        this.zzcnp.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzac.zzw(onCompleteListener);
        this.zzcnp.zzaJ(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, final @NonNull Continuation<TResult, TContinuationResult> continuation) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcnp.zza(null, executor, new OnCompleteListener<TResult>(){

            public void onComplete(@NonNull Task<TResult> task) {
                Object object;
                try {
                    object = continuation.then((Task)StorageTask.this);
                }
                catch (RuntimeExecutionException runtimeExecutionException) {
                    if (runtimeExecutionException.getCause() instanceof Exception) {
                        taskCompletionSource.setException((Exception)runtimeExecutionException.getCause());
                    } else {
                        taskCompletionSource.setException((Exception)((Object)runtimeExecutionException));
                    }
                    return;
                }
                catch (Exception exception) {
                    taskCompletionSource.setException(exception);
                    return;
                }
                if (!taskCompletionSource.getTask().isComplete()) {
                    taskCompletionSource.setResult(object);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, final @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcnp.zza(null, executor, new OnCompleteListener<TResult>(){

            public void onComplete(@NonNull Task<TResult> task) {
                Task task2;
                try {
                    task2 = (Task)continuation.then((Task)StorageTask.this);
                }
                catch (RuntimeExecutionException runtimeExecutionException) {
                    if (runtimeExecutionException.getCause() instanceof Exception) {
                        taskCompletionSource.setException((Exception)runtimeExecutionException.getCause());
                    } else {
                        taskCompletionSource.setException((Exception)((Object)runtimeExecutionException));
                    }
                    return;
                }
                catch (Exception exception) {
                    taskCompletionSource.setException(exception);
                    return;
                }
                if (!taskCompletionSource.getTask().isComplete()) {
                    if (task2 == null) {
                        taskCompletionSource.setException((Exception)new NullPointerException("Continuation returned null"));
                        return;
                    }
                    task2.addOnSuccessListener(new OnSuccessListener<TContinuationResult>(){

                        public void onSuccess(TContinuationResult TContinuationResult) {
                            taskCompletionSource.setResult(TContinuationResult);
                        }
                    });
                    task2.addOnFailureListener(new OnFailureListener(){

                        public void onFailure(@NonNull Exception exception) {
                            taskCompletionSource.setException(exception);
                        }
                    });
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    Runnable zzUK() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    StorageTask.this.run();
                }
                finally {
                    StorageTask.this.zzacE();
                }
            }
        };
    }

    private void zzacE() {
        if (!(this.isComplete() || this.isPaused() || this.zzacA() == 2 || this.zzf(256, false))) {
            this.zzf(64, false);
        }
    }

    private String zzqM(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static {
        zzcnl.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zzcnl.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzcnl.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzcnl.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzcnl.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzcnm.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zzcnm.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzcnm.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzcnm.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzcnm.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    @VisibleForTesting
    class SnapshotBase
    implements ProvideError {
        private final Exception zzcnw;

        public SnapshotBase(Exception exception) {
            this.zzcnw = exception == null ? (StorageTask.this.isCanceled() ? StorageException.fromErrorStatus(Status.zzazB) : (StorageTask.this.zzacA() == 64 ? StorageException.fromErrorStatus(Status.zzazz) : null)) : exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return StorageTask.this;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zzcnw;
        }
    }

    protected static interface ProvideError {
        public Exception getError();
    }
}

