/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbtu;
import com.google.android.gms.internal.zzbtv;
import com.google.android.gms.internal.zzbua;
import com.google.android.gms.internal.zzbue;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzcmy;
    private final Uri mUri;
    private final long zzcoe;
    private final zzbtu zzcof;
    private final AtomicLong zzcog;
    private int zzcoh;
    private zzbtv zzcmA;
    private boolean zzcoi;
    private volatile StorageMetadata zzcne;
    private volatile Uri zzcoj;
    private volatile Exception zzbNL;
    private volatile Exception zzcok;
    private volatile int mResultCode;
    private volatile String zzcol;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzcog = new AtomicLong(0L);
        this.zzcoh = 262144;
        this.zzcoj = null;
        this.zzbNL = null;
        this.zzcok = null;
        this.mResultCode = 0;
        zzac.zzw((Object)storageReference);
        zzac.zzw((Object)byArray);
        this.zzcoe = byArray.length;
        this.zzcmy = storageReference;
        this.zzcne = storageMetadata;
        this.mUri = null;
        this.zzcof = new zzbtu(new ByteArrayInputStream(byArray), 262144);
        this.zzcoi = true;
        this.zzcmA = new zzbtv(this.zzcmy.getApp(), this.zzcmy.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzcog = new AtomicLong(0L);
            this.zzcoh = 262144;
            this.zzcoj = null;
            this.zzbNL = null;
            this.zzcok = null;
            this.mResultCode = 0;
            zzac.zzw((Object)storageReference);
            zzac.zzw((Object)uri);
            this.zzcmy = storageReference;
            this.zzcne = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzcmA = new zzbtv(this.zzcmy.getApp(), this.zzcmy.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzcmy.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzbNL = fileNotFoundException;
            }
        }
        this.zzcoe = l;
        this.zzcof = new zzbtu(inputStream, 262144);
        this.zzcoi = true;
        this.zzcoj = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzcog = new AtomicLong(0L);
        this.zzcoh = 262144;
        this.zzcoj = null;
        this.zzbNL = null;
        this.zzcok = null;
        this.mResultCode = 0;
        zzac.zzw((Object)storageReference);
        zzac.zzw((Object)inputStream);
        this.zzcoe = -1L;
        this.zzcmy = storageReference;
        this.zzcne = storageMetadata;
        this.zzcof = new zzbtu(inputStream, 262144);
        this.zzcoi = false;
        this.mUri = null;
        this.zzcmA = new zzbtv(this.zzcmy.getApp(), this.zzcmy.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.zzcmy;
    }

    long getTotalByteCount() {
        return this.zzcoe;
    }

    @Override
    protected void schedule() {
        zzd.zzacG().zzv(this.zzUK());
    }

    @Override
    void run() {
        this.zzcmA.reset();
        if (!this.zzf(4, false)) {
            Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
            return;
        }
        if (this.zzcmy.getParent() == null) {
            this.zzbNL = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.zzbNL != null) {
            return;
        }
        if (this.zzcoj == null) {
            this.zzacN();
        } else {
            this.zzbi(false);
        }
        boolean bl = this.zzacO();
        while (bl) {
            this.zzacQ();
            bl = this.zzacO();
            if (!bl) continue;
            this.zzf(4, false);
        }
        if (this.zzcoi) {
            try {
                this.zzcof.close();
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzbNL = null;
        this.zzcok = null;
        this.mResultCode = 0;
        this.zzcol = null;
    }

    private void zzacN() {
        Object object;
        String string = null;
        if (this.zzcne != null) {
            string = this.zzcne.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.zzcmy.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.zzcmy.zzacx().zza(this.zzcmy.zzacy(), this.zzcne != null ? this.zzcne.zzacw() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.zzbNL = throwable;
            return;
        }
        if (!this.zzc((zzbue)object)) {
            return;
        }
        String string2 = ((zzbue)object).zzjO("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzcoj = Uri.parse((String)string2);
        }
    }

    private boolean zzacO() {
        boolean bl;
        if (this.zzacA() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbNL = new InterruptedException();
            this.zzf(64, false);
            return false;
        }
        if (this.zzacA() == 32) {
            this.zzf(256, false);
            return false;
        }
        if (this.zzacA() == 8) {
            this.zzf(16, false);
            return false;
        }
        if (!this.zzacP()) {
            return false;
        }
        if (this.zzcoj == null) {
            if (this.zzbNL == null) {
                this.zzbNL = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzf(64, false);
            return false;
        }
        if (this.zzbNL != null) {
            this.zzf(64, false);
            return false;
        }
        boolean bl2 = bl = this.zzcok != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzbi(true)) {
            if (this.zzacP()) {
                this.zzf(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean zzacP() {
        if ("final".equals(this.zzcol)) {
            if (this.zzbNL == null) {
                this.zzbNL = new IOException("The server has terminated the upload session");
            }
            this.zzf(64, false);
            return false;
        }
        return true;
    }

    private boolean zzbi(boolean bl) {
        zzbue zzbue2;
        try {
            zzbue2 = this.zzcmy.zzacx().zzb(this.zzcmy.zzacy(), this.zzcoj.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbNL = remoteException;
            return false;
        }
        if ("final".equals(this.zzcol)) {
            return false;
        }
        if (bl ? !this.zzc(zzbue2) : !this.zzb(zzbue2)) {
            return false;
        }
        if ("final".equals(zzbue2.zzjO("X-Goog-Upload-Status"))) {
            this.zzbNL = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzbue2.zzjO("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzcog.get();
        if (l2 > l) {
            this.zzbNL = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzcof.zzqN((int)(l - l2)) != l - l2) {
                    this.zzbNL = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzcog.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbNL = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbNL = iOException;
                return false;
            }
        }
        return true;
    }

    private void zzacQ() {
        block9: {
            try {
                zzbue zzbue2;
                this.zzcof.zzqO(this.zzcoh);
                int n = Math.min(this.zzcoh, this.zzcof.available());
                try {
                    zzbue2 = this.zzcmy.zzacx().zza(this.zzcmy.zzacy(), this.zzcoj.toString(), this.zzcof.zzacU(), this.zzcog.get(), n, this.zzcof.isFinished());
                }
                catch (RemoteException remoteException) {
                    Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                    this.zzbNL = remoteException;
                    return;
                }
                if (!this.zzb(zzbue2)) {
                    int n2 = this.zzcoh = 262144;
                    Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                    return;
                }
                this.zzcog.getAndAdd(n);
                if (!this.zzcof.isFinished()) {
                    this.zzcof.zzqN(n);
                    if (this.zzcoh < 0x2000000) {
                        this.zzcoh *= 2;
                        int n3 = this.zzcoh;
                        Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                    }
                    break block9;
                }
                try {
                    this.zzcne = new StorageMetadata.Builder(zzbue2.zzade(), this.zzcmy).build();
                }
                catch (RemoteException | JSONException throwable) {
                    String string = String.valueOf(zzbue2.zzacY());
                    Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                    this.zzbNL = throwable;
                    return;
                }
                this.zzf(4, false);
                this.zzf(128, false);
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                this.zzbNL = iOException;
            }
        }
    }

    private boolean zzqJ(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zzb(zzbue zzbue2) {
        zzbue2.zzd(zzbua.zzi(this.zzcmy.getApp()), this.zzcmy.getApp().getApplicationContext());
        return this.zzd(zzbue2);
    }

    private boolean zzc(zzbue zzbue2) {
        this.zzcmA.zze(zzbue2);
        return this.zzd(zzbue2);
    }

    private boolean zzd(zzbue zzbue2) {
        int n = zzbue2.getResultCode();
        this.mResultCode = this.zzcmA.zzqQ(n) ? -2 : n;
        this.zzcok = zzbue2.getException();
        this.zzcol = zzbue2.zzjO("X-Goog-Upload-Status");
        return this.zzqJ(this.mResultCode) && this.zzcok == null;
    }

    @Override
    protected void onCanceled() {
        this.zzcmA.cancel();
        zzbue zzbue2 = null;
        if (this.zzcoj != null) {
            try {
                zzbue2 = this.zzcmy.zzacx().zza(this.zzcmy.zzacy(), this.zzcoj.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzbue2 != null) {
            final zzbue zzbue3 = zzbue2;
            zzd.zzacG().zzu(new Runnable(){

                @Override
                public void run() {
                    zzbue3.zzd(zzbua.zzi(UploadTask.this.zzcmy.getApp()), UploadTask.this.zzcmy.getApp().getApplicationContext());
                }
            });
        }
        this.zzbNL = StorageException.fromErrorStatus(Status.zzazB);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot zzacR() {
        Exception exception = this.zzbNL != null ? this.zzbNL : this.zzcok;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.zzcog.get(), this.zzcoj, this.zzcne);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzacu() {
        return this.zzacR();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcoo;
        private final Uri zzcoj;
        private final StorageMetadata zzcne;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.zzcoo = l;
            this.zzcoj = uri;
            this.zzcne = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzcoo;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzcoj;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzcne;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

