/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbtw;
import com.google.android.gms.internal.zzbua;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzcmY = null;
    private StorageReference zzcmG = null;
    private String zzcmZ = null;
    private String zzcna = null;
    private String zzaoj = null;
    private String zzcnb = null;
    private String zzcnc = null;
    private String zzcnd = null;
    private long zzcne;
    private String zzcnf = null;
    private String zzcng = null;
    private String zzcnh = null;
    private String zzcni = null;
    private String zzcnj = null;
    private Map<String, String> zzcnk = null;
    private String[] zzcnl = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzac.zzw((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzcmY = storageMetadata.zzcmY;
        this.zzcmG = storageMetadata.zzcmG;
        this.zzcmZ = storageMetadata.zzcmZ;
        this.zzaoj = storageMetadata.zzaoj;
        this.zzcng = storageMetadata.zzcng;
        this.zzcnh = storageMetadata.zzcnh;
        this.zzcni = storageMetadata.zzcni;
        this.zzcnj = storageMetadata.zzcnj;
        if (storageMetadata.zzcnk != null) {
            this.zzcnk = new HashMap<String, String>(storageMetadata.zzcnk);
        }
        this.zzcnl = storageMetadata.zzcnl;
        if (bl) {
            this.zzcnf = storageMetadata.zzcnf;
            this.zzcne = storageMetadata.zzcne;
            this.zzcnd = storageMetadata.zzcnd;
            this.zzcnc = storageMetadata.zzcnc;
            this.zzcnb = storageMetadata.zzcnb;
            this.zzcna = storageMetadata.zzcna;
        }
    }

    public String getContentType() {
        return this.zzaoj;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzcnk == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzcnk.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzcnk == null) {
            return Collections.emptySet();
        }
        return this.zzcnk.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzcmZ;
    }

    @Nullable
    public String getGeneration() {
        return this.zzcna;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzcnb;
    }

    public long getCreationTimeMillis() {
        return zzbua.zzjL(this.zzcnc);
    }

    public long getUpdatedTimeMillis() {
        return zzbua.zzjL(this.zzcnd);
    }

    public long getSizeBytes() {
        return this.zzcne;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzcnf;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzcnl != null && this.zzcmG != null) {
            try {
                String string = this.zzcmG.zzacy().zzA(this.zzcmG.zzacz());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.zzcnl) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzcng;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzcnh;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzcni;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzcnj;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzcmG == null && this.zzcmY != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzbtw.zzjI((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzcmY);
        }
        return this.zzcmG;
    }

    @NonNull
    JSONObject zzacx() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzcnk != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzcnk));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zzjH(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzcnl = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata zzcnm;
        boolean zzcnn;

        public Builder() {
            this.zzcnm = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzcnm = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzcnm.zzcmG = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.zzcnm = new StorageMetadata();
            if (jSONObject != null) {
                this.zzu(jSONObject);
                this.zzcnn = true;
            }
        }

        private void zzu(JSONObject jSONObject) throws JSONException {
            this.zzcnm.zzcna = jSONObject.optString("generation");
            this.zzcnm.mPath = jSONObject.optString("name");
            this.zzcnm.zzcmZ = jSONObject.optString("bucket");
            this.zzcnm.zzcnb = jSONObject.optString("metageneration");
            this.zzcnm.zzcnc = jSONObject.optString("timeCreated");
            this.zzcnm.zzcnd = jSONObject.optString("updated");
            this.zzcnm.zzcne = jSONObject.optLong("size");
            this.zzcnm.zzcnf = jSONObject.optString("md5Hash");
            this.zzcnm.zzjH(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzcnm, this.zzcnn);
        }

        public Builder setContentLanguage(String string) {
            this.zzcnm.zzcnj = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzcnm.zzcni = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzcnm.zzcnh = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzcnm.zzcng = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzcnm.zzcnk == null) {
                this.zzcnm.zzcnk = new HashMap();
            }
            this.zzcnm.zzcnk.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzcnm.zzaoj = string;
            return this;
        }
    }
}

