/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.agq;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class agv {
    private agq zzcsT;
    private Exception zzbMl;
    private int zzcsU;
    private Exception zzcsV;

    public agv(@NonNull agq agq2) {
        this.zzcsT = agq2;
    }

    public final void zzan(String string, String string2) {
        try {
            this.zzcsT.zzan(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzin(String string) {
        try {
            return this.zzcsT.zzin(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            agv agv2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                agv2.zzcsU = -2;
                agv2.zzcsV = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzcsT.zzil(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzcsU = 0;
            this.zzcsV = null;
            this.zzcsT.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzim(@Nullable String string) {
        try {
            this.zzcsT.zzim(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzLv() {
        try {
            if (this.zzcsT != null) {
                this.zzcsT.zzLv();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzE((IObjectWrapper)this.zzcsT.zzLw());
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzLD() throws RemoteException {
        return (JSONObject)zzn.zzE((IObjectWrapper)this.zzcsT.zzLx());
    }

    @Nullable
    public final String zzLy() {
        try {
            this.zzcsT.zzLy();
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzcsV != null) {
                return this.zzcsV;
            }
            if (this.zzbMl != null) {
                return this.zzbMl;
            }
            return (Exception)zzn.zzE((IObjectWrapper)this.zzcsT.zzLz());
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzcsU != 0) {
                return this.zzcsU;
            }
            return this.zzcsT.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzLA() {
        try {
            if (this.zzcsU == -2 || this.zzcsV != null) {
                return false;
            }
            return this.zzcsT.zzLA();
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzLA() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzLB() {
        try {
            return this.zzcsT.zzLB();
        }
        catch (RemoteException remoteException) {
            this.zzbMl = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

