/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzi;
import com.google.firebase.storage.zzj;
import com.google.firebase.storage.zzk;
import com.google.firebase.storage.zzl;
import com.google.firebase.storage.zzm;
import com.google.firebase.storage.zzn;
import com.google.firebase.storage.zzo;
import com.google.firebase.storage.zzr;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzw;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zzcrA = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzcrB = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    private zzw<OnSuccessListener<? super TResult>, TResult> zzcrC = new zzw(this, 128, new zzi(this));
    @VisibleForTesting
    private zzw<OnFailureListener, TResult> zzcrD = new zzw(this, 320, new zzj(this));
    @VisibleForTesting
    private zzw<OnCompleteListener<TResult>, TResult> zzcrE = new zzw(this, 448, new zzk(this));
    @VisibleForTesting
    private zzw<OnProgressListener<? super TResult>, TResult> zzcrF = new zzw(this, -465, new zzl(this));
    @VisibleForTesting
    private zzw<OnPausedListener<? super TResult>, TResult> zzcrG = new zzw(this, 16, new zzm(this));
    private volatile int zzOp = 1;
    private TResult zzcrH;

    protected StorageTask() {
    }

    @VisibleForTesting
    final boolean zzLg() {
        if (this.zzj(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzj(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zza(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.zza(new int[]{256, 32}, true);
    }

    public boolean isComplete() {
        return (this.zzOp & 0x80) != 0 || (this.zzOp & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzOp & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzOp == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzOp & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzOp & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzLj() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzLj().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzLj();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzLj() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzLj().getError())) {
            throw (Throwable)clazz.cast(this.zzLj().getError());
        }
        Exception exception = this.zzLj().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzLj();
    }

    @Nullable
    public Exception getException() {
        if (this.zzLj() == null) {
            return null;
        }
        return this.zzLj().getError();
    }

    public TResult getSnapshot() {
        return this.zzLi();
    }

    @VisibleForTesting
    final int zzLh() {
        return this.zzOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    final TResult zzLi() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzLc();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzLc();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zza(int[] nArray, boolean bl) {
        HashMap<Integer, HashSet<Integer>> hashMap = bl ? zzcrA : zzcrB;
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = object2[i];
                HashSet<Integer> hashSet = hashMap.get(this.zzOp);
                if (hashSet == null || !hashSet.contains(n2)) continue;
                this.zzOp = n2;
                switch (this.zzOp) {
                    case 2: {
                        zzs.zzLl().zzb(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzcrC.zzLp();
                this.zzcrD.zzLp();
                this.zzcrE.zzLp();
                this.zzcrG.zzLp();
                this.zzcrF.zzLp();
                if (Log.isLoggable((String)"StorageTask", (int)3)) {
                    String string = String.valueOf(StorageTask.zzce(n2));
                    String string2 = String.valueOf(StorageTask.zzce(this.zzOp));
                    Log.d((String)"StorageTask", (String)new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string2).length()).append("changed internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
                }
                return true;
            }
            object2 = String.valueOf(StorageTask.zzd(nArray));
            String string = String.valueOf(StorageTask.zzce(this.zzOp));
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(object2).length() + String.valueOf(string).length()).append("unable to change internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append(string).toString());
            return false;
        }
    }

    @VisibleForTesting
    final boolean zzj(int n, boolean bl) {
        return this.zza(new int[]{n}, bl);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private final TResult zzLj() {
        if (this.zzcrH != null) {
            return this.zzcrH;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzcrH == null) {
            this.zzcrH = this.zzLi();
        }
        return this.zzcrH;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbr.zzu(onPausedListener);
        this.zzcrG.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbr.zzu(onPausedListener);
        zzbr.zzu((Object)executor);
        this.zzcrG.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbr.zzu(onPausedListener);
        zzbr.zzu((Object)activity);
        this.zzcrG.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbr.zzu(onPausedListener);
        this.zzcrG.zzat(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbr.zzu(onProgressListener);
        this.zzcrF.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbr.zzu(onProgressListener);
        zzbr.zzu((Object)executor);
        this.zzcrF.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbr.zzu(onProgressListener);
        zzbr.zzu((Object)activity);
        this.zzcrF.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbr.zzu(onProgressListener);
        this.zzcrF.zzat(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbr.zzu(onSuccessListener);
        this.zzcrC.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbr.zzu((Object)executor);
        zzbr.zzu(onSuccessListener);
        this.zzcrC.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbr.zzu((Object)activity);
        zzbr.zzu(onSuccessListener);
        this.zzcrC.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbr.zzu(onSuccessListener);
        this.zzcrC.zzat(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbr.zzu((Object)onFailureListener);
        this.zzcrD.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzbr.zzu((Object)onFailureListener);
        zzbr.zzu((Object)executor);
        this.zzcrD.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzbr.zzu((Object)onFailureListener);
        zzbr.zzu((Object)activity);
        this.zzcrD.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbr.zzu((Object)onFailureListener);
        this.zzcrD.zzat(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbr.zzu(onCompleteListener);
        this.zzcrE.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbr.zzu(onCompleteListener);
        zzbr.zzu((Object)executor);
        this.zzcrE.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbr.zzu(onCompleteListener);
        zzbr.zzu((Object)activity);
        this.zzcrE.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbr.zzu(onCompleteListener);
        this.zzcrE.zzat(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcrE.zza(null, executor, new zzn(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcrE.zza(null, executor, new zzo(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    final Runnable zzEc() {
        return new zzr(this);
    }

    private final void zzLk() {
        if (!(this.isComplete() || this.isPaused() || this.zzOp == 2 || this.zzj(256, false))) {
            this.zzj(64, false);
        }
    }

    private static String zzd(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            stringBuilder.append(StorageTask.zzce(n2)).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static String zzce(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void zza(StorageTask storageTask) {
        storageTask.zzLk();
    }

    static {
        zzcrA.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zzcrA.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzcrA.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzcrA.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzcrA.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzcrB.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zzcrB.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzcrB.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzcrB.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzcrB.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception zzcrL;
        private /* synthetic */ StorageTask zzcrI;

        public SnapshotBase(StorageTask storageTask, Exception exception) {
            this.zzcrI = storageTask;
            if (exception == null) {
                if (storageTask.isCanceled()) {
                    this.zzcrL = StorageException.fromErrorStatus(Status.zzaBs);
                    return;
                }
                if (storageTask.zzLh() == 64) {
                    this.zzcrL = StorageException.fromErrorStatus(Status.zzaBq);
                    return;
                }
                this.zzcrL = null;
                return;
            }
            this.zzcrL = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return this.zzcrI;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zzcrL;
        }
    }

    public static interface ProvideError {
        public Exception getError();
    }
}

