/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.abr;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class abw {
    private abr zzcpV;
    private Exception zzbMh;
    private int zzcpW;
    private Exception zzcpX;

    public abw(@NonNull abr abr2) {
        this.zzcpV = abr2;
    }

    public final void zzam(String string, String string2) {
        try {
            this.zzcpV.zzam(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzhO(String string) {
        try {
            return this.zzcpV.zzhO(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            abw abw2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                abw2.zzcpW = -2;
                abw2.zzcpX = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzcpV.zzhM(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzcpW = 0;
            this.zzcpX = null;
            this.zzcpV.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzhN(@Nullable String string) {
        try {
            this.zzcpV.zzhN(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzLd() {
        try {
            if (this.zzcpV != null) {
                this.zzcpV.zzLd();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzE((IObjectWrapper)this.zzcpV.zzLe());
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzLl() throws RemoteException {
        return (JSONObject)zzn.zzE((IObjectWrapper)this.zzcpV.zzLf());
    }

    @Nullable
    public final String zzLg() {
        try {
            this.zzcpV.zzLg();
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzcpX != null) {
                return this.zzcpX;
            }
            if (this.zzbMh != null) {
                return this.zzbMh;
            }
            return (Exception)zzn.zzE((IObjectWrapper)this.zzcpV.zzLh());
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzcpW != 0) {
                return this.zzcpW;
            }
            return this.zzcpV.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzLi() {
        try {
            if (this.zzcpW == -2 || this.zzcpX != null) {
                return false;
            }
            return this.zzcpV.zzLi();
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzLi() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzLj() {
        try {
            return this.zzcpV.zzLj();
        }
        catch (RemoteException remoteException) {
            this.zzbMh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

