/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.abl;
import com.google.android.gms.internal.abv;
import com.google.android.gms.internal.abw;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzcnS;
    private long zzcnT;
    private StorageReference zzcnP;
    private abl zzcnR;
    private long zzaNq = -1L;
    private String zzcnU = null;
    private volatile Exception zzbMh = null;
    private long zzcnV = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzcnP = storageReference;
        this.zzcnS = uri;
        this.zzcnR = new abl(this.zzcnP.getStorage().getApp(), this.zzcnP.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzaNq;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzcnP;
    }

    @Override
    protected void schedule() {
        zzt.zzu(this.zzEe());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzbMh = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(abw abw2) throws IOException {
        boolean bl = true;
        InputStream inputStream = abw2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzcnS.getPath());
            if (!file.exists()) {
                if (this.zzcnV > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzcnV > 0L) {
                object = String.valueOf(file.getAbsolutePath());
                long l = this.zzcnV;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzcnT += (long)n;
                    if (this.zzbMh != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzbMh);
                        this.zzbMh = null;
                        bl = false;
                    }
                    if (this.zzj(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzbMh = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzbMh != null) {
            this.zzj(64, false);
            return;
        }
        if (!this.zzj(4, false)) {
            return;
        }
        do {
            Object object;
            abw abw2;
            this.zzcnT = 0L;
            this.zzbMh = null;
            this.zzcnR.reset();
            try {
                abw2 = abv.zzg(this.zzcnP.getStorage().getApp()).zza(this.zzcnP.zzKN(), this.zzcnV);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzbMh = remoteException;
                this.zzj(64, false);
                return;
            }
            this.zzcnR.zza(abw2, false);
            this.mResultCode = abw2.getResultCode();
            this.zzbMh = abw2.getException() != null ? abw2.getException() : this.zzbMh;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzbMh == null && this.zzKP() == 4;
            if (bl) {
                this.zzaNq = abw2.zzLj();
                object = abw2.zzhO("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzcnU != null && !this.zzcnU.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzcnV = 0L;
                    this.zzcnU = null;
                    abw2.zzLd();
                    this.schedule();
                    return;
                }
                this.zzcnU = object;
                try {
                    bl = this.zza(abw2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzbMh = iOException;
                }
            }
            abw2.zzLd();
            if (bl && this.zzbMh == null && this.zzKP() == 4) {
                this.zzj(128, false);
                return;
            }
            object = new File(this.zzcnS.getPath());
            this.zzcnV = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzKP() == 8) {
                this.zzj(16, false);
                return;
            }
            if (this.zzKP() != 32) continue;
            if (!this.zzj(256, false)) {
                int n2 = this.zzKP();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzcnT > 0L);
        this.zzj(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzcnR.cancel();
        this.zzbMh = StorageException.fromErrorStatus(Status.zzaBq);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzKK() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzbMh, fileDownloadTask.mResultCode)), fileDownloadTask.zzcnT + fileDownloadTask.zzcnV);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcnT;
        private /* synthetic */ FileDownloadTask zzcnW;

        TaskSnapshot(FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzcnW = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzcnT = l;
        }

        public long getBytesTransferred() {
            return this.zzcnT;
        }

        public long getTotalByteCount() {
            return this.zzcnW.getTotalBytes();
        }
    }
}

