/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abl;
import com.google.android.gms.internal.abw;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzv;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzcnP;
    private abl zzcnR;
    private volatile Exception zzbMh = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzcpa;
    private long zzaNq = -1L;
    private long zzcnT;
    private long zzcpb;
    private InputStream zzbSm;
    private abw zzcpc;
    private String zzcnU;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzcnP = storageReference;
        this.zzcnR = new abl(this.zzcnP.getStorage().getApp(), this.zzcnP.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbo.zzu((Object)streamProcessor);
        zzbo.zzae((this.zzcpa == null ? 1 : 0) != 0);
        this.zzcpa = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzcnP;
    }

    final long getTotalBytes() {
        return this.zzaNq;
    }

    final void zzaN(long l) {
        this.zzcnT += l;
        if (this.zzcpb + 262144L <= this.zzcnT) {
            if (this.zzKP() == 4) {
                this.zzj(4, false);
                return;
            }
            this.zzcpb = this.zzcnT;
        }
    }

    @Override
    protected void schedule() {
        zzt.zzu(this.zzEe());
    }

    private final InputStream zzKU() throws Exception {
        this.zzcnR.reset();
        if (this.zzcpc != null) {
            this.zzcpc.zzLd();
        }
        try {
            this.zzcpc = this.zzcnP.zzKM().zza(this.zzcnP.zzKN(), this.zzcnT);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzcnR.zza(this.zzcpc, false);
        this.mResultCode = this.zzcpc.getResultCode();
        this.zzbMh = this.zzcpc.getException() != null ? this.zzcpc.getException() : this.zzbMh;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzbMh == null && this.zzKP() == 4) {
            String string = this.zzcpc.zzhO("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzcnU != null && !this.zzcnU.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzcnU = string;
            if (this.zzaNq == -1L) {
                this.zzaNq = this.zzcpc.zzLj();
            }
            return this.zzcpc.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzbMh != null) {
            this.zzj(64, false);
            return;
        }
        if (!this.zzj(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzv(this), this);
        this.zzbSm = new BufferedInputStream(zza2);
        try {
            zza2.zzKW();
            if (this.zzcpa != null) {
                try {
                    this.zzcpa.doInBackground((TaskSnapshot)this.zzKQ(), this.zzbSm);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzbMh = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzbMh = iOException;
        }
        if (this.zzbSm == null) {
            this.zzcpc.zzLd();
            this.zzcpc = null;
        }
        if (this.zzbMh == null && this.zzKP() == 4) {
            this.zzj(4, false);
            this.zzj(128, false);
            return;
        }
        if (!this.zzj(this.zzKP() == 32 ? 256 : 64, false)) {
            int n = this.zzKP();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzcnR.cancel();
        this.zzbMh = StorageException.fromErrorStatus(Status.zzaBq);
    }

    @Override
    protected void onProgress() {
        this.zzcpb = this.zzcnT;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzKK() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzbMh, streamDownloadTask.mResultCode)), streamDownloadTask.zzcpb);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzKU();
    }

    static /* synthetic */ abw zza(StreamDownloadTask streamDownloadTask, abw abw2) {
        streamDownloadTask.zzcpc = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcnT;
        private /* synthetic */ StreamDownloadTask zzcpd;

        TaskSnapshot(StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzcpd = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzcnT = l;
        }

        public long getBytesTransferred() {
            return this.zzcnT;
        }

        public long getTotalByteCount() {
            return this.zzcpd.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzcpd.zzbSm;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzcpe;
        @Nullable
        private InputStream zzcpf;
        private Callable<InputStream> zzcpg;
        private IOException zzcph;
        private int zzcpi;
        private int zzcpj;
        private boolean zzcpk;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzcpe = streamDownloadTask;
            this.zzcpg = callable;
        }

        private final void zzKV() throws IOException {
            if (this.zzcpe != null && this.zzcpe.zzKP() == 32) {
                throw StorageException.zzcod;
            }
        }

        private final void zzaN(long l) {
            if (this.zzcpe != null) {
                this.zzcpe.zzaN(l);
            }
            this.zzcpi = (int)((long)this.zzcpi + l);
        }

        private final boolean zzKW() throws IOException {
            this.zzKV();
            if (this.zzcph != null) {
                try {
                    if (this.zzcpf != null) {
                        this.zzcpf.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzcpf = null;
                if (this.zzcpj == this.zzcpi) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzcph);
                    return false;
                }
                int n = this.zzcpi;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzcph);
                this.zzcpj = this.zzcpi;
                this.zzcph = null;
            }
            if (this.zzcpk) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzcpf == null) {
                try {
                    this.zzcpf = this.zzcpg.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzKW()) {
                try {
                    int n = this.zzcpf.read();
                    if (n != -1) {
                        this.zzaN(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcph = iOException;
                }
            }
            throw this.zzcph;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzKW()) {
                try {
                    return this.zzcpf.available();
                }
                catch (IOException iOException) {
                    this.zzcph = iOException;
                }
            }
            throw this.zzcph;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzcpf != null) {
                this.zzcpf.close();
            }
            this.zzcpk = true;
            if (this.zzcpe != null && this.zzcpe.zzcpc != null) {
                this.zzcpe.zzcpc.zzLd();
                StreamDownloadTask.zza(this.zzcpe, null);
            }
            this.zzKV();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzKW()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzcpf.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzaN(n4);
                        this.zzKV();
                    }
                    if (n2 > 0) {
                        n4 = this.zzcpf.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzaN(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzcph = iOException;
                }
            }
            throw this.zzcph;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzKW()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzcpf.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzaN(l2);
                        this.zzKV();
                    }
                    if (l > 0L) {
                        l2 = this.zzcpf.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzaN(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcph = iOException;
                }
            }
            throw this.zzcph;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

