/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.abu;
import com.google.android.gms.internal.ace;
import com.google.android.gms.internal.acf;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzcnW;
    private long zzcnX;
    private StorageReference zzcnT;
    private abu zzcnV;
    private long zzaNq = -1L;
    private String zzcnY = null;
    private volatile Exception zzbMj = null;
    private long zzcnZ = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzcnT = storageReference;
        this.zzcnW = uri;
        this.zzcnV = new abu(this.zzcnT.getStorage().getApp(), this.zzcnT.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzaNq;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzcnT;
    }

    @Override
    protected void schedule() {
        zzt.zzu(this.zzEf());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzbMj = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(acf acf2) throws IOException {
        boolean bl = true;
        InputStream inputStream = acf2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzcnW.getPath());
            if (!file.exists()) {
                if (this.zzcnZ > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzcnZ > 0L) {
                object = String.valueOf(file.getAbsolutePath());
                long l = this.zzcnZ;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzcnX += (long)n;
                    if (this.zzbMj != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzbMj);
                        this.zzbMj = null;
                        bl = false;
                    }
                    if (this.zzj(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzbMj = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzbMj != null) {
            this.zzj(64, false);
            return;
        }
        if (!this.zzj(4, false)) {
            return;
        }
        do {
            Object object;
            acf acf2;
            this.zzcnX = 0L;
            this.zzbMj = null;
            this.zzcnV.reset();
            try {
                acf2 = ace.zzg(this.zzcnT.getStorage().getApp()).zza(this.zzcnT.zzKQ(), this.zzcnZ);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzbMj = remoteException;
                this.zzj(64, false);
                return;
            }
            this.zzcnV.zza(acf2, false);
            this.mResultCode = acf2.getResultCode();
            this.zzbMj = acf2.getException() != null ? acf2.getException() : this.zzbMj;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzbMj == null && this.zzKS() == 4;
            if (bl) {
                this.zzaNq = acf2.zzLm();
                object = acf2.zzhQ("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzcnY != null && !this.zzcnY.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzcnZ = 0L;
                    this.zzcnY = null;
                    acf2.zzLg();
                    this.schedule();
                    return;
                }
                this.zzcnY = object;
                try {
                    bl = this.zza(acf2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzbMj = iOException;
                }
            }
            acf2.zzLg();
            if (bl && this.zzbMj == null && this.zzKS() == 4) {
                this.zzj(128, false);
                return;
            }
            object = new File(this.zzcnW.getPath());
            this.zzcnZ = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzKS() == 8) {
                this.zzj(16, false);
                return;
            }
            if (this.zzKS() != 32) continue;
            if (!this.zzj(256, false)) {
                int n2 = this.zzKS();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzcnX > 0L);
        this.zzj(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzcnV.cancel();
        this.zzbMj = StorageException.fromErrorStatus(Status.zzaBq);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzKN() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzbMj, fileDownloadTask.mResultCode)), fileDownloadTask.zzcnX + fileDownloadTask.zzcnZ);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcnX;
        private /* synthetic */ FileDownloadTask zzcoa;

        TaskSnapshot(FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzcoa = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzcnX = l;
        }

        public long getBytesTransferred() {
            return this.zzcnX;
        }

        public long getTotalByteCount() {
            return this.zzcoa.getTotalBytes();
        }
    }
}

