/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abv;
import com.google.android.gms.internal.abz;
import com.google.android.gms.internal.ace;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzc;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzcol = null;
    private StorageReference zzcnT = null;
    private String zzcom = null;
    private String zzcon = null;
    private String zzapZ = null;
    private String zzcoo = null;
    private String zzcop = null;
    private String zzcoq = null;
    private long zzcor;
    private String zzcos = null;
    private String zzcot = null;
    private String zzcou = null;
    private String zzcov = null;
    private String zzcow = null;
    private Map<String, String> zzcox = null;
    private String[] zzcoy = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbo.zzu((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzcol = storageMetadata.zzcol;
        this.zzcnT = storageMetadata.zzcnT;
        this.zzcom = storageMetadata.zzcom;
        this.zzapZ = storageMetadata.zzapZ;
        this.zzcot = storageMetadata.zzcot;
        this.zzcou = storageMetadata.zzcou;
        this.zzcov = storageMetadata.zzcov;
        this.zzcow = storageMetadata.zzcow;
        if (storageMetadata.zzcox != null) {
            this.zzcox = new HashMap<String, String>(storageMetadata.zzcox);
        }
        this.zzcoy = storageMetadata.zzcoy;
        if (bl) {
            this.zzcos = storageMetadata.zzcos;
            this.zzcor = storageMetadata.zzcor;
            this.zzcoq = storageMetadata.zzcoq;
            this.zzcop = storageMetadata.zzcop;
            this.zzcoo = storageMetadata.zzcoo;
            this.zzcon = storageMetadata.zzcon;
        }
    }

    public String getContentType() {
        return this.zzapZ;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzcox == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzcox.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzcox == null) {
            return Collections.emptySet();
        }
        return this.zzcox.keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzcom;
    }

    @Nullable
    public String getGeneration() {
        return this.zzcon;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzcoo;
    }

    public long getCreationTimeMillis() {
        return abz.zzhN(this.zzcop);
    }

    public long getUpdatedTimeMillis() {
        return abz.zzhN(this.zzcoq);
    }

    public long getSizeBytes() {
        return this.zzcor;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzcos;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzcoy != null && this.zzcnT != null) {
            try {
                String string = ace.zzg(this.zzcnT.getStorage().getApp()).zzv(this.zzcnT.zzKQ());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzcoy;
                    int n = this.zzcoy.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzcot;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzcou;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzcov;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzcow;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzcnT == null && this.zzcol != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(abv.zzhK((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzcol);
        }
        return this.zzcnT;
    }

    @NonNull
    final JSONObject zzKO() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzcox != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzcox));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private final void zzhJ(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzcoy = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzc zzc2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzcoz;
        private boolean zzcoA;

        public Builder() {
            this.zzcoz = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzcoz = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzcoz.zzcnT = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzcoz = new StorageMetadata();
            if (jSONObject != null) {
                this.zzt(jSONObject);
                this.zzcoA = true;
            }
        }

        private final void zzt(JSONObject jSONObject) throws JSONException {
            this.zzcoz.zzcon = jSONObject.optString("generation");
            this.zzcoz.mPath = jSONObject.optString("name");
            this.zzcoz.zzcom = jSONObject.optString("bucket");
            this.zzcoz.zzcoo = jSONObject.optString("metageneration");
            this.zzcoz.zzcop = jSONObject.optString("timeCreated");
            this.zzcoz.zzcoq = jSONObject.optString("updated");
            this.zzcoz.zzcor = jSONObject.optLong("size");
            this.zzcoz.zzcos = jSONObject.optString("md5Hash");
            this.zzcoz.zzhJ(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzcoz, this.zzcoA, null);
        }

        public Builder setContentLanguage(String string) {
            this.zzcoz.zzcow = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzcoz.zzcov = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzcoz.zzcou = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzcoz.zzcot = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzcoz.zzcox == null) {
                this.zzcoz.zzcox = new HashMap();
            }
            this.zzcoz.zzcox.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzcoz.zzapZ = string;
            return this;
        }
    }
}

