/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzi;
import com.google.firebase.storage.zzj;
import com.google.firebase.storage.zzk;
import com.google.firebase.storage.zzl;
import com.google.firebase.storage.zzm;
import com.google.firebase.storage.zzn;
import com.google.firebase.storage.zzo;
import com.google.firebase.storage.zzr;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzw;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zzcoG = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzcoH = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    private zzw<OnSuccessListener<? super TResult>, TResult> zzcoI = new zzw(this, 128, new zzi(this));
    @VisibleForTesting
    private zzw<OnFailureListener, TResult> zzcoJ = new zzw(this, 320, new zzj(this));
    @VisibleForTesting
    private zzw<OnCompleteListener<TResult>, TResult> zzcoK = new zzw(this, 448, new zzk(this));
    @VisibleForTesting
    private zzw<OnProgressListener<? super TResult>, TResult> zzcoL = new zzw(this, -465, new zzl(this));
    @VisibleForTesting
    private zzw<OnPausedListener<? super TResult>, TResult> zzcoM = new zzw(this, 16, new zzm(this));
    private volatile int zzOn = 1;
    private TResult zzcoN;

    protected StorageTask() {
    }

    @VisibleForTesting
    final boolean zzKR() {
        if (this.zzj(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzj(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zza(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.zza(new int[]{256, 32}, true);
    }

    public boolean isComplete() {
        return (this.zzOn & 0x80) != 0 || (this.zzOn & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzOn & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzOn == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzOn & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzOn & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzKU() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzKU().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzKU();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzKU() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzKU().getError())) {
            throw (Throwable)clazz.cast(this.zzKU().getError());
        }
        Exception exception = this.zzKU().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzKU();
    }

    @Nullable
    public Exception getException() {
        if (this.zzKU() == null) {
            return null;
        }
        return this.zzKU().getError();
    }

    public TResult getSnapshot() {
        return this.zzKT();
    }

    @VisibleForTesting
    final int zzKS() {
        return this.zzOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    final TResult zzKT() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzKN();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzKN();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zza(int[] nArray, boolean bl) {
        HashMap<Integer, HashSet<Integer>> hashMap = bl ? zzcoG : zzcoH;
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = object2[i];
                HashSet<Integer> hashSet = hashMap.get(this.zzOn);
                if (hashSet == null || !hashSet.contains(n2)) continue;
                this.zzOn = n2;
                switch (this.zzOn) {
                    case 2: {
                        zzs.zzKW().zzb(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzcoI.zzLa();
                this.zzcoJ.zzLa();
                this.zzcoK.zzLa();
                this.zzcoM.zzLa();
                this.zzcoL.zzLa();
                if (Log.isLoggable((String)"StorageTask", (int)3)) {
                    String string = String.valueOf(StorageTask.zzcf(n2));
                    String string2 = String.valueOf(StorageTask.zzcf(this.zzOn));
                    Log.d((String)"StorageTask", (String)new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string2).length()).append("changed internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
                }
                return true;
            }
            object2 = String.valueOf(StorageTask.zzd(nArray));
            String string = String.valueOf(StorageTask.zzcf(this.zzOn));
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(object2).length() + String.valueOf(string).length()).append("unable to change internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append(string).toString());
            return false;
        }
    }

    @VisibleForTesting
    final boolean zzj(int n, boolean bl) {
        return this.zza(new int[]{n}, bl);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private final TResult zzKU() {
        if (this.zzcoN != null) {
            return this.zzcoN;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzcoN == null) {
            this.zzcoN = this.zzKT();
        }
        return this.zzcoN;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbo.zzu(onPausedListener);
        this.zzcoM.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbo.zzu(onPausedListener);
        zzbo.zzu((Object)executor);
        this.zzcoM.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbo.zzu(onPausedListener);
        zzbo.zzu((Object)activity);
        this.zzcoM.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbo.zzu(onPausedListener);
        this.zzcoM.zzat(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbo.zzu(onProgressListener);
        this.zzcoL.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbo.zzu(onProgressListener);
        zzbo.zzu((Object)executor);
        this.zzcoL.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbo.zzu(onProgressListener);
        zzbo.zzu((Object)activity);
        this.zzcoL.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbo.zzu(onProgressListener);
        this.zzcoL.zzat(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbo.zzu(onSuccessListener);
        this.zzcoI.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbo.zzu((Object)executor);
        zzbo.zzu(onSuccessListener);
        this.zzcoI.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbo.zzu((Object)activity);
        zzbo.zzu(onSuccessListener);
        this.zzcoI.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbo.zzu(onSuccessListener);
        this.zzcoI.zzat(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbo.zzu((Object)onFailureListener);
        this.zzcoJ.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzbo.zzu((Object)onFailureListener);
        zzbo.zzu((Object)executor);
        this.zzcoJ.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzbo.zzu((Object)onFailureListener);
        zzbo.zzu((Object)activity);
        this.zzcoJ.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbo.zzu((Object)onFailureListener);
        this.zzcoJ.zzat(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbo.zzu(onCompleteListener);
        this.zzcoK.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbo.zzu(onCompleteListener);
        zzbo.zzu((Object)executor);
        this.zzcoK.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbo.zzu(onCompleteListener);
        zzbo.zzu((Object)activity);
        this.zzcoK.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbo.zzu(onCompleteListener);
        this.zzcoK.zzat(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcoK.zza(null, executor, new zzn(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcoK.zza(null, executor, new zzo(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    final Runnable zzEf() {
        return new zzr(this);
    }

    private final void zzKV() {
        if (!(this.isComplete() || this.isPaused() || this.zzOn == 2 || this.zzj(256, false))) {
            this.zzj(64, false);
        }
    }

    private static String zzd(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            stringBuilder.append(StorageTask.zzcf(n2)).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static String zzcf(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void zza(StorageTask storageTask) {
        storageTask.zzKV();
    }

    static {
        zzcoG.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zzcoG.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzcoG.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzcoG.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzcoG.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzcoH.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zzcoH.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzcoH.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzcoH.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzcoH.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception zzcoR;
        private /* synthetic */ StorageTask zzcoO;

        public SnapshotBase(StorageTask storageTask, Exception exception) {
            this.zzcoO = storageTask;
            if (exception == null) {
                if (storageTask.isCanceled()) {
                    this.zzcoR = StorageException.fromErrorStatus(Status.zzaBq);
                    return;
                }
                if (storageTask.zzKS() == 64) {
                    this.zzcoR = StorageException.fromErrorStatus(Status.zzaBo);
                    return;
                }
                this.zzcoR = null;
                return;
            }
            this.zzcoR = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return this.zzcoO;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zzcoR;
        }
    }

    public static interface ProvideError {
        public Exception getError();
    }
}

