/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abu;
import com.google.android.gms.internal.acf;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzv;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzcnT;
    private abu zzcnV;
    private volatile Exception zzbMj = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzcpe;
    private long zzaNq = -1L;
    private long zzcnX;
    private long zzcpf;
    private InputStream zzbSo;
    private acf zzcpg;
    private String zzcnY;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzcnT = storageReference;
        this.zzcnV = new abu(this.zzcnT.getStorage().getApp(), this.zzcnT.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbo.zzu((Object)streamProcessor);
        zzbo.zzae((this.zzcpe == null ? 1 : 0) != 0);
        this.zzcpe = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzcnT;
    }

    final long getTotalBytes() {
        return this.zzaNq;
    }

    final void zzaN(long l) {
        this.zzcnX += l;
        if (this.zzcpf + 262144L <= this.zzcnX) {
            if (this.zzKS() == 4) {
                this.zzj(4, false);
                return;
            }
            this.zzcpf = this.zzcnX;
        }
    }

    @Override
    protected void schedule() {
        zzt.zzu(this.zzEf());
    }

    private final InputStream zzKX() throws Exception {
        this.zzcnV.reset();
        if (this.zzcpg != null) {
            this.zzcpg.zzLg();
        }
        try {
            this.zzcpg = this.zzcnT.zzKP().zza(this.zzcnT.zzKQ(), this.zzcnX);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzcnV.zza(this.zzcpg, false);
        this.mResultCode = this.zzcpg.getResultCode();
        this.zzbMj = this.zzcpg.getException() != null ? this.zzcpg.getException() : this.zzbMj;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzbMj == null && this.zzKS() == 4) {
            String string = this.zzcpg.zzhQ("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzcnY != null && !this.zzcnY.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzcnY = string;
            if (this.zzaNq == -1L) {
                this.zzaNq = this.zzcpg.zzLm();
            }
            return this.zzcpg.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzbMj != null) {
            this.zzj(64, false);
            return;
        }
        if (!this.zzj(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzv(this), this);
        this.zzbSo = new BufferedInputStream(zza2);
        try {
            zza2.zzKZ();
            if (this.zzcpe != null) {
                try {
                    this.zzcpe.doInBackground((TaskSnapshot)this.zzKT(), this.zzbSo);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzbMj = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzbMj = iOException;
        }
        if (this.zzbSo == null) {
            this.zzcpg.zzLg();
            this.zzcpg = null;
        }
        if (this.zzbMj == null && this.zzKS() == 4) {
            this.zzj(4, false);
            this.zzj(128, false);
            return;
        }
        if (!this.zzj(this.zzKS() == 32 ? 256 : 64, false)) {
            int n = this.zzKS();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzcnV.cancel();
        this.zzbMj = StorageException.fromErrorStatus(Status.zzaBq);
    }

    @Override
    protected void onProgress() {
        this.zzcpf = this.zzcnX;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzKN() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzbMj, streamDownloadTask.mResultCode)), streamDownloadTask.zzcpf);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzKX();
    }

    static /* synthetic */ acf zza(StreamDownloadTask streamDownloadTask, acf acf2) {
        streamDownloadTask.zzcpg = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcnX;
        private /* synthetic */ StreamDownloadTask zzcph;

        TaskSnapshot(StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzcph = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzcnX = l;
        }

        public long getBytesTransferred() {
            return this.zzcnX;
        }

        public long getTotalByteCount() {
            return this.zzcph.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzcph.zzbSo;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzcpi;
        @Nullable
        private InputStream zzcpj;
        private Callable<InputStream> zzcpk;
        private IOException zzcpl;
        private int zzcpm;
        private int zzcpn;
        private boolean zzcpo;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzcpi = streamDownloadTask;
            this.zzcpk = callable;
        }

        private final void zzKY() throws IOException {
            if (this.zzcpi != null && this.zzcpi.zzKS() == 32) {
                throw StorageException.zzcoh;
            }
        }

        private final void zzaN(long l) {
            if (this.zzcpi != null) {
                this.zzcpi.zzaN(l);
            }
            this.zzcpm = (int)((long)this.zzcpm + l);
        }

        private final boolean zzKZ() throws IOException {
            this.zzKY();
            if (this.zzcpl != null) {
                try {
                    if (this.zzcpj != null) {
                        this.zzcpj.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzcpj = null;
                if (this.zzcpn == this.zzcpm) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzcpl);
                    return false;
                }
                int n = this.zzcpm;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzcpl);
                this.zzcpn = this.zzcpm;
                this.zzcpl = null;
            }
            if (this.zzcpo) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzcpj == null) {
                try {
                    this.zzcpj = this.zzcpk.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzKZ()) {
                try {
                    int n = this.zzcpj.read();
                    if (n != -1) {
                        this.zzaN(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcpl = iOException;
                }
            }
            throw this.zzcpl;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzKZ()) {
                try {
                    return this.zzcpj.available();
                }
                catch (IOException iOException) {
                    this.zzcpl = iOException;
                }
            }
            throw this.zzcpl;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzcpj != null) {
                this.zzcpj.close();
            }
            this.zzcpo = true;
            if (this.zzcpi != null && this.zzcpi.zzcpg != null) {
                this.zzcpi.zzcpg.zzLg();
                StreamDownloadTask.zza(this.zzcpi, null);
            }
            this.zzKY();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzKZ()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzcpj.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzaN(n4);
                        this.zzKY();
                    }
                    if (n2 > 0) {
                        n4 = this.zzcpj.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzaN(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzcpl = iOException;
                }
            }
            throw this.zzcpl;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzKZ()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzcpj.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzaN(l2);
                        this.zzKY();
                    }
                    if (l > 0L) {
                        l2 = this.zzcpj.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzaN(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcpl = iOException;
                }
            }
            throw this.zzcpl;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

