/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abt;
import com.google.android.gms.internal.abu;
import com.google.android.gms.internal.abz;
import com.google.android.gms.internal.acf;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzac;
import com.google.firebase.storage.zzt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzcnT;
    private final Uri mUri;
    private final long zzcpz;
    private final abt zzcpA;
    private final AtomicLong zzcpB;
    private int zzcpC;
    private abu zzcnV;
    private boolean zzcpD;
    private volatile StorageMetadata zzcoz;
    private volatile Uri zzcpE;
    private volatile Exception zzbMj;
    private volatile Exception zzcpF;
    private volatile int mResultCode;
    private volatile String zzcpG;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzcpB = new AtomicLong(0L);
        this.zzcpC = 262144;
        this.zzcpE = null;
        this.zzbMj = null;
        this.zzcpF = null;
        this.mResultCode = 0;
        zzbo.zzu((Object)storageReference);
        zzbo.zzu((Object)byArray);
        this.zzcpz = byArray.length;
        this.zzcnT = storageReference;
        this.zzcoz = storageMetadata;
        this.mUri = null;
        this.zzcpA = new abt(new ByteArrayInputStream(byArray), 262144);
        this.zzcpD = true;
        this.zzcnV = new abu(this.zzcnT.getStorage().getApp(), this.zzcnT.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzcpB = new AtomicLong(0L);
            this.zzcpC = 262144;
            this.zzcpE = null;
            this.zzbMj = null;
            this.zzcpF = null;
            this.mResultCode = 0;
            zzbo.zzu((Object)storageReference);
            zzbo.zzu((Object)uri);
            this.zzcnT = storageReference;
            this.zzcoz = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzcnV = new abu(this.zzcnT.getStorage().getApp(), this.zzcnT.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzcnT.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzbMj = fileNotFoundException;
            }
        }
        this.zzcpz = l;
        this.zzcpA = new abt(inputStream, 262144);
        this.zzcpD = true;
        this.zzcpE = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzcpB = new AtomicLong(0L);
        this.zzcpC = 262144;
        this.zzcpE = null;
        this.zzbMj = null;
        this.zzcpF = null;
        this.mResultCode = 0;
        zzbo.zzu((Object)storageReference);
        zzbo.zzu((Object)inputStream);
        this.zzcpz = -1L;
        this.zzcnT = storageReference;
        this.zzcoz = storageMetadata;
        this.zzcpA = new abt(inputStream, 262144);
        this.zzcpD = false;
        this.mUri = null;
        this.zzcnV = new abu(this.zzcnT.getStorage().getApp(), this.zzcnT.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzcnT;
    }

    final long getTotalByteCount() {
        return this.zzcpz;
    }

    @Override
    protected void schedule() {
        zzt.zzt(this.zzEf());
    }

    @Override
    final void run() {
        acf acf2;
        UploadTask uploadTask;
        block24: {
            this.zzcnV.reset();
            if (!this.zzj(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzcnT.getParent() == null) {
                this.zzbMj = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzbMj != null) {
                return;
            }
            if (this.zzcpE == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzcoz != null) {
                    string2 = uploadTask.zzcoz.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzcnT.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    acf2 = uploadTask.zzcnT.zzKP().zza(uploadTask.zzcnT.zzKQ(), uploadTask.zzcoz != null ? uploadTask.zzcoz.zzKO() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzbMj = throwable;
                    break block24;
                }
                if (uploadTask.zzc(acf2) && !TextUtils.isEmpty((CharSequence)(string = acf2.zzhQ("X-Goog-Upload-URL")))) {
                    uploadTask.zzcpE = Uri.parse((String)string);
                }
            } else {
                this.zzaK(false);
            }
        }
        boolean bl = this.zzLb();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzcpA.zzch(uploadTask.zzcpC);
                    int n = Math.min(uploadTask.zzcpC, uploadTask.zzcpA.available());
                    try {
                        acf2 = uploadTask.zzcnT.zzKP().zza(uploadTask.zzcnT.zzKQ(), uploadTask.zzcpE.toString(), uploadTask.zzcpA.zzLf(), uploadTask.zzcpB.get(), n, uploadTask.zzcpA.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzbMj = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(acf2)) {
                        int n2 = uploadTask.zzcpC = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzcpB.getAndAdd(n);
                    if (!uploadTask.zzcpA.isFinished()) {
                        uploadTask.zzcpA.zzcg(n);
                        if (uploadTask.zzcpC < 0x2000000) {
                            uploadTask.zzcpC <<= 1;
                            int n3 = uploadTask.zzcpC;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzcoz = new StorageMetadata.Builder(acf2.zzLo(), uploadTask.zzcnT).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(acf2.zzLj());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzbMj = throwable;
                        break block25;
                    }
                    uploadTask.zzj(4, false);
                    uploadTask.zzj(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzbMj = iOException;
                }
            }
            if (!(bl = this.zzLb())) continue;
            this.zzj(4, false);
        }
        if (this.zzcpD && this.zzKS() != 16) {
            try {
                this.zzcpA.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzbMj = null;
        this.zzcpF = null;
        this.mResultCode = 0;
        this.zzcpG = null;
    }

    private final boolean zzLb() {
        if (this.zzKS() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbMj = new InterruptedException();
            this.zzj(64, false);
            return false;
        }
        if (this.zzKS() == 32) {
            this.zzj(256, false);
            return false;
        }
        if (this.zzKS() == 8) {
            this.zzj(16, false);
            return false;
        }
        if (!this.zzLc()) {
            return false;
        }
        if (this.zzcpE == null) {
            if (this.zzbMj == null) {
                this.zzbMj = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzj(64, false);
            return false;
        }
        if (this.zzbMj != null) {
            this.zzj(64, false);
            return false;
        }
        if ((this.zzcpF != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzaK(true)) {
            if (this.zzLc()) {
                this.zzj(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzLc() {
        if ("final".equals(this.zzcpG)) {
            if (this.zzbMj == null) {
                this.zzbMj = new IOException("The server has terminated the upload session");
            }
            this.zzj(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzaK(boolean bl) {
        acf acf2;
        try {
            acf2 = this.zzcnT.zzKP().zzb(this.zzcnT.zzKQ(), this.zzcpE.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbMj = remoteException;
            return false;
        }
        if ("final".equals(this.zzcpG)) {
            return false;
        }
        if (bl ? !this.zzc(acf2) : !this.zzb(acf2)) {
            return false;
        }
        if ("final".equals(acf2.zzhQ("X-Goog-Upload-Status"))) {
            this.zzbMj = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = acf2.zzhQ("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzcpB.get();
        if (l2 > l) {
            this.zzbMj = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzcpA.zzcg((int)(l - l2)) != l - l2) {
                    this.zzbMj = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzcpB.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbMj = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbMj = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(acf acf2) {
        acf2.zze(abz.zzf(this.zzcnT.getStorage().getApp()), this.zzcnT.getStorage().getApp().getApplicationContext());
        return this.zzd(acf2);
    }

    private final boolean zzc(acf acf2) {
        acf acf3 = acf2;
        this.zzcnV.zza(acf3, true);
        return this.zzd(acf2);
    }

    private final boolean zzd(acf acf2) {
        int n = acf2.getResultCode();
        this.mResultCode = abu.zzcj(n) ? -2 : n;
        this.zzcpF = acf2.getException();
        this.zzcpG = acf2.zzhQ("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzcpF == null;
    }

    @Override
    protected void onCanceled() {
        this.zzcnV.cancel();
        acf acf2 = null;
        if (this.zzcpE != null) {
            try {
                acf2 = this.zzcnT.zzKP().zza(this.zzcnT.zzKQ(), this.zzcpE.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (acf2 != null) {
            acf acf3 = acf2;
            zzt.zzs(new zzac(this, acf3));
        }
        this.zzbMj = StorageException.fromErrorStatus(Status.zzaBq);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzKN() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzbMj != null ? uploadTask.zzbMj : uploadTask.zzcpF;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzcpB.get(), uploadTask.zzcpE, uploadTask.zzcoz);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzcnT;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcpJ;
        private final Uri zzcpE;
        private final StorageMetadata zzcoz;
        private /* synthetic */ UploadTask zzcpI;

        TaskSnapshot(UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzcpI = uploadTask;
            super(uploadTask, exception);
            this.zzcpJ = l;
            this.zzcpE = uri;
            this.zzcoz = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzcpJ;
        }

        public long getTotalByteCount() {
            return this.zzcpI.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzcpE;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzcoz;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

