/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public final class zzebs {
    private static final Runtime zzmua = Runtime.getRuntime();
    private final InputStream zzmub;
    private byte[] buffer;
    private int zzmuc;
    private boolean zzmud;
    private boolean zzmue;

    public zzebs(InputStream inputStream, int n) {
        this.zzmub = inputStream;
        this.buffer = new byte[262144];
        this.zzmuc = 0;
        this.zzmue = true;
        this.zzmud = false;
    }

    public final int available() {
        return this.zzmuc;
    }

    public final byte[] zzcaw() {
        return this.buffer;
    }

    public final int zzgd(int n) throws IOException {
        int n2;
        if (n <= this.zzmuc) {
            this.zzmuc -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzmuc);
            n2 = n;
        } else {
            n2 = this.zzmuc = 0;
            while (n2 < n) {
                long l = this.zzmub.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzmub.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public final int zzge(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzgf(n));
        }
        while (this.zzmuc < n) {
            int n2 = this.zzmub.read(this.buffer, this.zzmuc, n - this.zzmuc);
            if (n2 == -1) {
                this.zzmud = true;
                break;
            }
            this.zzmuc += n2;
        }
        return this.zzmuc;
    }

    private final int zzgf(int n) {
        int n2 = Math.max(this.buffer.length << 1, n);
        if (this.zzmue && (long)(n2 + 262144) < zzmua.freeMemory()) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzmuc);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzmue = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public final boolean isFinished() {
        return this.zzmud;
    }

    public final void close() throws IOException {
        this.zzmub.close();
    }
}

