/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzecb;
import com.google.android.gms.internal.zzecc;
import com.google.android.gms.internal.zzece;
import com.google.firebase.FirebaseApp;
import org.json.JSONObject;

public final class zzecd {
    private static final Object zzmui = new Object();
    private static volatile zzecd zzmuj;
    private zzecb zzmuk;
    private Context mContext;
    private FirebaseApp zzmix;

    private zzecd(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        this.mContext = firebaseApp.getApplicationContext();
        this.zzmix = firebaseApp;
        try {
            IInterface iInterface;
            DynamiteModule dynamiteModule = DynamiteModule.zza((Context)this.mContext, (DynamiteModule.zzd)DynamiteModule.zzgpj, (String)"com.google.android.gms.firebasestorage");
            IBinder iBinder = dynamiteModule.zzgv("com.google.firebase.storage.network.NetworkRequestFactoryImpl");
            this.zzmuk = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.firebase.storage.network.INetworkRequestFactory")) instanceof zzecb ? (zzecb)iInterface : new zzecc(iBinder));
        }
        catch (DynamiteModule.zzc zzc2) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"NetworkRequestFactoryProxy failed with a RemoteException:", (Throwable)zzc2);
            throw new RemoteException();
        }
        if (this.zzmuk == null) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"Unable to load Firebase Storage Network layer.");
            throw new RemoteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzecd zzg(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        if (zzmuj == null) {
            Object object = zzmui;
            synchronized (object) {
                if (zzmuj == null) {
                    zzmuj = new zzecd(firebaseApp);
                }
            }
        }
        return zzmuj;
    }

    private final zzece zze(zzece zzece2) {
        zzece2.zzbp("x-firebase-gmpid", this.zzmix.getOptions().getApplicationId());
        return zzece2;
    }

    @NonNull
    public final zzece zzw(Uri uri) throws RemoteException {
        return this.zze(new zzece(this.zzmuk.zza(uri, zzn.zzw((Object)this.mContext))));
    }

    @NonNull
    public final zzece zzx(Uri uri) throws RemoteException {
        return this.zze(new zzece(this.zzmuk.zzb(uri, zzn.zzw((Object)this.mContext))));
    }

    @NonNull
    public final zzece zza(Uri uri, long l) throws RemoteException {
        return this.zze(new zzece(this.zzmuk.zza(uri, zzn.zzw((Object)this.mContext), l)));
    }

    @NonNull
    public final zzece zza(Uri uri, String string, byte[] byArray, long l, int n, boolean bl) throws RemoteException {
        return this.zze(new zzece(this.zzmuk.zza(uri, zzn.zzw((Object)this.mContext), string, zzn.zzw((Object)byArray), l, n, bl)));
    }

    @Nullable
    public final zzece zza(Uri uri, String string) throws RemoteException {
        return this.zze(new zzece(this.zzmuk.zza(uri, zzn.zzw((Object)this.mContext), string)));
    }

    @NonNull
    public final zzece zzb(Uri uri, String string) throws RemoteException {
        return this.zze(new zzece(this.zzmuk.zzb(uri, zzn.zzw((Object)this.mContext), string)));
    }

    @NonNull
    public final zzece zza(Uri uri, JSONObject jSONObject, String string) throws RemoteException {
        return this.zze(new zzece(this.zzmuk.zza(uri, zzn.zzw((Object)this.mContext), zzn.zzw((Object)jSONObject), string)));
    }

    @NonNull
    public final zzece zza(Uri uri, JSONObject jSONObject) throws RemoteException {
        return this.zze(new zzece(this.zzmuk.zza(uri, zzn.zzw((Object)this.mContext), zzn.zzw((Object)jSONObject))));
    }

    @Nullable
    public final String zzcbe() {
        try {
            return this.zzmuk.zzcbe();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getBackendAuthority failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @Nullable
    public final String zzv(Uri uri) {
        try {
            return this.zzmuk.zzv(uri);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getDefaultURL failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }
}

