/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzebt;
import com.google.android.gms.internal.zzecd;
import com.google.android.gms.internal.zzece;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzmqg;
    private long zzmqh;
    private StorageReference zzmqd;
    private zzebt zzmqf;
    private long zzgft = -1L;
    private String zzmqi = null;
    private volatile Exception zzkgb = null;
    private long zzmqj = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzmqd = storageReference;
        this.zzmqg = uri;
        this.zzmqf = new zzebt(this.zzmqd.getStorage().getApp(), this.zzmqd.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzgft;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzmqd;
    }

    @Override
    protected void schedule() {
        zzu.zzr(this.zzbjc());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzkgb = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzece zzece2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzece2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzmqg.getPath());
            if (!file.exists()) {
                if (this.zzmqj > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzmqj > 0L) {
                object = file.getAbsolutePath();
                long l = this.zzmqj;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzmqh += (long)n;
                    if (this.zzkgb != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzkgb);
                        this.zzkgb = null;
                        bl = false;
                    }
                    if (this.zzk(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzkgb = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzkgb != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        do {
            Object object;
            zzece zzece2;
            this.zzmqh = 0L;
            this.zzkgb = null;
            this.zzmqf.reset();
            try {
                zzece2 = zzecd.zzg(this.zzmqd.getStorage().getApp()).zza(this.zzmqd.zzcah(), this.zzmqj);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzkgb = remoteException;
                this.zzk(64, false);
                return;
            }
            this.zzmqf.zza(zzece2, false);
            this.mResultCode = zzece2.getResultCode();
            this.zzkgb = zzece2.getException() != null ? zzece2.getException() : this.zzkgb;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzkgb == null && this.zzcaj() == 4;
            if (bl) {
                this.zzgft = zzece2.zzcbd();
                object = zzece2.zzqz("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzmqi != null && !this.zzmqi.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzmqj = 0L;
                    this.zzmqi = null;
                    zzece2.zzcax();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zzmqi = object;
                try {
                    bl = this.zza(zzece2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzkgb = iOException;
                }
            }
            zzece2.zzcax();
            if (bl && this.zzkgb == null && this.zzcaj() == 4) {
                this.zzk(128, false);
                return;
            }
            object = new File(this.zzmqg.getPath());
            this.zzmqj = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcaj() == 8) {
                this.zzk(16, false);
                return;
            }
            if (this.zzcaj() != 32) continue;
            if (!this.zzk(256, false)) {
                int n2 = this.zzcaj();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzmqh > 0L);
        this.zzk(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzmqf.cancel();
        this.zzkgb = StorageException.fromErrorStatus(Status.zzfht);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcad() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzkgb, fileDownloadTask.mResultCode)), fileDownloadTask.zzmqh + fileDownloadTask.zzmqj);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmqh;
        private /* synthetic */ FileDownloadTask zzmqk;

        TaskSnapshot(@Nullable FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzmqk = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzmqh = l;
        }

        public long getBytesTransferred() {
            return this.zzmqh;
        }

        public long getTotalByteCount() {
            return this.zzmqk.getTotalBytes();
        }
    }
}

