/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.CancellableTask;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzj;
import com.google.firebase.storage.zzk;
import com.google.firebase.storage.zzl;
import com.google.firebase.storage.zzm;
import com.google.firebase.storage.zzn;
import com.google.firebase.storage.zzo;
import com.google.firebase.storage.zzp;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzx;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zzmrs = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzmrt = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    private zzx<OnSuccessListener<? super TResult>, TResult> zzmru = new zzx(this, 128, new zzj(this));
    @VisibleForTesting
    private zzx<OnFailureListener, TResult> zzmrv = new zzx(this, 320, new zzk(this));
    @VisibleForTesting
    private zzx<OnCompleteListener<TResult>, TResult> zzmrw = new zzx(this, 448, new zzl(this));
    @VisibleForTesting
    private zzx<OnProgressListener<? super TResult>, TResult> zzmrx = new zzx(this, -465, new zzm(this));
    @VisibleForTesting
    private zzx<OnPausedListener<? super TResult>, TResult> zzmry = new zzx(this, 16, new zzn(this));
    private volatile int zzcfg = 1;
    private TResult zzmrz;

    protected StorageTask() {
    }

    @VisibleForTesting
    final boolean zzcai() {
        if (this.zzk(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzk(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zza(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.zza(new int[]{256, 32}, true);
    }

    public boolean isComplete() {
        return (this.zzcfg & 0x80) != 0 || (this.zzcfg & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzcfg & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzcfg == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzcfg & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzcfg & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzcal() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzcal().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzcal();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzcal() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzcal().getError())) {
            throw (Throwable)clazz.cast(this.zzcal().getError());
        }
        Exception exception = this.zzcal().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzcal();
    }

    @Nullable
    public Exception getException() {
        if (this.zzcal() == null) {
            return null;
        }
        return this.zzcal().getError();
    }

    public TResult getSnapshot() {
        return this.zzcak();
    }

    @VisibleForTesting
    final int zzcaj() {
        return this.zzcfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    final TResult zzcak() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzcad();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzcad();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zza(int[] nArray, boolean bl) {
        HashMap<Integer, HashSet<Integer>> hashMap = bl ? zzmrs : zzmrt;
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = object2[i];
                HashSet<Integer> hashSet = hashMap.get(this.zzcfg);
                if (hashSet == null || !hashSet.contains(n2)) continue;
                this.zzcfg = n2;
                switch (this.zzcfg) {
                    case 2: {
                        zzt.zzcan().zzb(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzmru.zzcar();
                this.zzmrv.zzcar();
                this.zzmrw.zzcar();
                this.zzmry.zzcar();
                this.zzmrx.zzcar();
                if (Log.isLoggable((String)"StorageTask", (int)3)) {
                    String string = StorageTask.zzgc(n2);
                    String string2 = StorageTask.zzgc(this.zzcfg);
                    Log.d((String)"StorageTask", (String)new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string2).length()).append("changed internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
                }
                return true;
            }
            object2 = StorageTask.zzf(nArray);
            String string = StorageTask.zzgc(this.zzcfg);
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(object2).length() + String.valueOf(string).length()).append("unable to change internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append(string).toString());
            return false;
        }
    }

    @VisibleForTesting
    final boolean zzk(int n, boolean bl) {
        return this.zza(new int[]{n}, bl);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private final TResult zzcal() {
        if (this.zzmrz != null) {
            return this.zzmrz;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzmrz == null) {
            this.zzmrz = this.zzcak();
        }
        return this.zzmrz;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        this.zzmry.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        zzbp.zzu((Object)executor);
        this.zzmry.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        zzbp.zzu((Object)activity);
        this.zzmry.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        this.zzmry.zzbv(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        this.zzmrx.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        zzbp.zzu((Object)executor);
        this.zzmrx.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        zzbp.zzu((Object)activity);
        this.zzmrx.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        this.zzmrx.zzbv(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu(onSuccessListener);
        this.zzmru.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu((Object)executor);
        zzbp.zzu(onSuccessListener);
        this.zzmru.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu((Object)activity);
        zzbp.zzu(onSuccessListener);
        this.zzmru.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu(onSuccessListener);
        this.zzmru.zzbv(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        this.zzmrv.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        zzbp.zzu((Object)executor);
        this.zzmrv.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        zzbp.zzu((Object)activity);
        this.zzmrv.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        this.zzmrv.zzbv(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        this.zzmrw.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        zzbp.zzu((Object)executor);
        this.zzmrw.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        zzbp.zzu((Object)activity);
        this.zzmrw.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        this.zzmrw.zzbv(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzmrw.zza(null, executor, new zzo(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzmrw.zza(null, executor, new zzp(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    final Runnable zzbjc() {
        return new zzs(this);
    }

    private final void zzcam() {
        if (!(this.isComplete() || ((ControllableTask)this).isPaused() || this.zzcfg == 2 || this.zzk(256, false))) {
            this.zzk(64, false);
        }
    }

    private static String zzf(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            stringBuilder.append(StorageTask.zzgc(n2)).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static String zzgc(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void zza(StorageTask storageTask) {
        storageTask.zzcam();
    }

    static {
        zzmrs.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zzmrs.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzmrs.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzmrs.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzmrs.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzmrt.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zzmrt.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzmrt.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzmrt.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzmrt.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception zzmsd;
        private /* synthetic */ StorageTask zzmsa;

        public SnapshotBase(@Nullable StorageTask storageTask, Exception exception) {
            this.zzmsa = storageTask;
            if (exception == null) {
                if (((CancellableTask)storageTask).isCanceled()) {
                    this.zzmsd = StorageException.fromErrorStatus(Status.zzfht);
                    return;
                }
                if (storageTask.zzcaj() == 64) {
                    this.zzmsd = StorageException.fromErrorStatus(Status.zzfhr);
                    return;
                }
                this.zzmsd = null;
                return;
            }
            this.zzmsd = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return this.zzmsa;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zzmsd;
        }
    }

    public static interface ProvideError {
        public Exception getError();
    }
}

