/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzebt;
import com.google.android.gms.internal.zzece;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import com.google.firebase.storage.zzw;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzmqd;
    private zzebt zzmqf;
    private volatile Exception zzkgb = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzmsq;
    private long zzgft = -1L;
    private long zzmqh;
    private long zzmsr;
    private InputStream zzksd;
    private zzece zzmss;
    private String zzmqi;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzmqd = storageReference;
        this.zzmqf = new zzebt(this.zzmqd.getStorage().getApp(), this.zzmqd.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbp.zzu((Object)streamProcessor);
        zzbp.zzbg((this.zzmsq == null ? 1 : 0) != 0);
        this.zzmsq = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzmqd;
    }

    final long getTotalBytes() {
        return this.zzgft;
    }

    final void zzcm(long l) {
        this.zzmqh += l;
        if (this.zzmsr + 262144L <= this.zzmqh) {
            if (this.zzcaj() == 4) {
                this.zzk(4, false);
                return;
            }
            this.zzmsr = this.zzmqh;
        }
    }

    @Override
    protected void schedule() {
        zzu.zzr(this.zzbjc());
    }

    private final InputStream zzcao() throws Exception {
        this.zzmqf.reset();
        if (this.zzmss != null) {
            this.zzmss.zzcax();
        }
        try {
            this.zzmss = this.zzmqd.zzcag().zza(this.zzmqd.zzcah(), this.zzmqh);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzmqf.zza(this.zzmss, false);
        this.mResultCode = this.zzmss.getResultCode();
        this.zzkgb = this.zzmss.getException() != null ? this.zzmss.getException() : this.zzkgb;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzkgb == null && this.zzcaj() == 4) {
            String string = this.zzmss.zzqz("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzmqi != null && !this.zzmqi.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzmqi = string;
            if (this.zzgft == -1L) {
                this.zzgft = this.zzmss.zzcbd();
            }
            return this.zzmss.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzkgb != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzw(this), this);
        this.zzksd = new BufferedInputStream(zza2);
        try {
            zza2.zzcaq();
            if (this.zzmsq != null) {
                try {
                    this.zzmsq.doInBackground((TaskSnapshot)this.zzcak(), this.zzksd);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzkgb = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzkgb = iOException;
        }
        if (this.zzksd == null) {
            this.zzmss.zzcax();
            this.zzmss = null;
        }
        if (this.zzkgb == null && this.zzcaj() == 4) {
            this.zzk(4, false);
            this.zzk(128, false);
            return;
        }
        if (!this.zzk(this.zzcaj() == 32 ? 256 : 64, false)) {
            int n = this.zzcaj();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzmqf.cancel();
        this.zzkgb = StorageException.fromErrorStatus(Status.zzfht);
    }

    @Override
    protected void onProgress() {
        this.zzmsr = this.zzmqh;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcad() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzkgb, streamDownloadTask.mResultCode)), streamDownloadTask.zzmsr);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzcao();
    }

    static /* synthetic */ zzece zza(StreamDownloadTask streamDownloadTask, zzece zzece2) {
        streamDownloadTask.zzmss = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmqh;
        private /* synthetic */ StreamDownloadTask zzmst;

        TaskSnapshot(@Nullable StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzmst = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzmqh = l;
        }

        public long getBytesTransferred() {
            return this.zzmqh;
        }

        public long getTotalByteCount() {
            return this.zzmst.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzmst.zzksd;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzmsu;
        @Nullable
        private InputStream zzmsv;
        private Callable<InputStream> zzmsw;
        private IOException zzmsx;
        private int zzmsy;
        private int zzmsz;
        private boolean zzmta;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzmsu = streamDownloadTask;
            this.zzmsw = callable;
        }

        private final void zzcap() throws IOException {
            if (this.zzmsu != null && this.zzmsu.zzcaj() == 32) {
                throw new com.google.firebase.storage.zza();
            }
        }

        private final void zzcm(long l) {
            if (this.zzmsu != null) {
                this.zzmsu.zzcm(l);
            }
            this.zzmsy = (int)((long)this.zzmsy + l);
        }

        private final boolean zzcaq() throws IOException {
            this.zzcap();
            if (this.zzmsx != null) {
                try {
                    if (this.zzmsv != null) {
                        this.zzmsv.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzmsv = null;
                if (this.zzmsz == this.zzmsy) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzmsx);
                    return false;
                }
                int n = this.zzmsy;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzmsx);
                this.zzmsz = this.zzmsy;
                this.zzmsx = null;
            }
            if (this.zzmta) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzmsv == null) {
                try {
                    this.zzmsv = this.zzmsw.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzcaq()) {
                try {
                    int n = this.zzmsv.read();
                    if (n != -1) {
                        this.zzcm(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzmsx = iOException;
                }
            }
            throw this.zzmsx;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzcaq()) {
                try {
                    return this.zzmsv.available();
                }
                catch (IOException iOException) {
                    this.zzmsx = iOException;
                }
            }
            throw this.zzmsx;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzmsv != null) {
                this.zzmsv.close();
            }
            this.zzmta = true;
            if (this.zzmsu != null && this.zzmsu.zzmss != null) {
                this.zzmsu.zzmss.zzcax();
                StreamDownloadTask.zza(this.zzmsu, null);
            }
            this.zzcap();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzcaq()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzmsv.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzcm(n4);
                        this.zzcap();
                    }
                    if (n2 > 0) {
                        n4 = this.zzmsv.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzcm(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzmsx = iOException;
                }
            }
            throw this.zzmsx;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzcaq()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzmsv.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcm(l2);
                        this.zzcap();
                    }
                    if (l > 0L) {
                        l2 = this.zzmsv.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcm(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzmsx = iOException;
                }
            }
            throw this.zzmsx;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

