/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public final class zzecj {
    private static final Runtime zzmxg = Runtime.getRuntime();
    private final InputStream zzmxh;
    private byte[] buffer;
    private int zzmxi;
    private boolean zzmxj;
    private boolean zzmxk;

    public zzecj(InputStream inputStream, int n) {
        this.zzmxh = inputStream;
        this.buffer = new byte[262144];
        this.zzmxi = 0;
        this.zzmxk = true;
        this.zzmxj = false;
    }

    public final int available() {
        return this.zzmxi;
    }

    public final byte[] zzcbd() {
        return this.buffer;
    }

    public final int zzgf(int n) throws IOException {
        int n2;
        if (n <= this.zzmxi) {
            this.zzmxi -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzmxi);
            n2 = n;
        } else {
            n2 = this.zzmxi = 0;
            while (n2 < n) {
                long l = this.zzmxh.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzmxh.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public final int zzgg(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzgh(n));
        }
        while (this.zzmxi < n) {
            int n2 = this.zzmxh.read(this.buffer, this.zzmxi, n - this.zzmxi);
            if (n2 == -1) {
                this.zzmxj = true;
                break;
            }
            this.zzmxi += n2;
        }
        return this.zzmxi;
    }

    private final int zzgh(int n) {
        int n2 = Math.max(this.buffer.length << 1, n);
        if (this.zzmxk && (long)(n2 + 262144) < zzmxg.freeMemory()) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzmxi);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzmxk = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public final boolean isFinished() {
        return this.zzmxj;
    }

    public final void close() throws IOException {
        this.zzmxh.close();
    }
}

