/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzecs;
import com.google.android.gms.internal.zzect;
import com.google.android.gms.internal.zzecv;
import com.google.firebase.FirebaseApp;
import org.json.JSONObject;

public final class zzecu {
    private static final Object zzmxo = new Object();
    private static volatile zzecu zzmxp;
    private zzecs zzmxq;
    private Context mContext;
    private FirebaseApp zzmlk;

    private zzecu(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        this.mContext = firebaseApp.getApplicationContext();
        this.zzmlk = firebaseApp;
        try {
            IInterface iInterface;
            DynamiteModule dynamiteModule = DynamiteModule.zza((Context)this.mContext, (DynamiteModule.zzd)DynamiteModule.zzgpr, (String)"com.google.android.gms.firebasestorage");
            IBinder iBinder = dynamiteModule.zzgv("com.google.firebase.storage.network.NetworkRequestFactoryImpl");
            this.zzmxq = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.firebase.storage.network.INetworkRequestFactory")) instanceof zzecs ? (zzecs)iInterface : new zzect(iBinder));
        }
        catch (DynamiteModule.zzc zzc2) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"NetworkRequestFactoryProxy failed with a RemoteException:", (Throwable)zzc2);
            throw new RemoteException();
        }
        if (this.zzmxq == null) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"Unable to load Firebase Storage Network layer.");
            throw new RemoteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzecu zzg(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        if (zzmxp == null) {
            Object object = zzmxo;
            synchronized (object) {
                if (zzmxp == null) {
                    zzmxp = new zzecu(firebaseApp);
                }
            }
        }
        return zzmxp;
    }

    private final zzecv zze(zzecv zzecv2) {
        zzecv2.zzbo("x-firebase-gmpid", this.zzmlk.getOptions().getApplicationId());
        return zzecv2;
    }

    @NonNull
    public final zzecv zzv(Uri uri) throws RemoteException {
        return this.zze(new zzecv(this.zzmxq.zza(uri, zzn.zzw((Object)this.mContext))));
    }

    @NonNull
    public final zzecv zzw(Uri uri) throws RemoteException {
        return this.zze(new zzecv(this.zzmxq.zzb(uri, zzn.zzw((Object)this.mContext))));
    }

    @NonNull
    public final zzecv zza(Uri uri, long l) throws RemoteException {
        return this.zze(new zzecv(this.zzmxq.zza(uri, zzn.zzw((Object)this.mContext), l)));
    }

    @NonNull
    public final zzecv zza(Uri uri, String string, byte[] byArray, long l, int n, boolean bl) throws RemoteException {
        return this.zze(new zzecv(this.zzmxq.zza(uri, zzn.zzw((Object)this.mContext), string, zzn.zzw((Object)byArray), l, n, bl)));
    }

    @Nullable
    public final zzecv zza(Uri uri, String string) throws RemoteException {
        return this.zze(new zzecv(this.zzmxq.zza(uri, zzn.zzw((Object)this.mContext), string)));
    }

    @NonNull
    public final zzecv zzb(Uri uri, String string) throws RemoteException {
        return this.zze(new zzecv(this.zzmxq.zzb(uri, zzn.zzw((Object)this.mContext), string)));
    }

    @NonNull
    public final zzecv zza(Uri uri, JSONObject jSONObject, String string) throws RemoteException {
        return this.zze(new zzecv(this.zzmxq.zza(uri, zzn.zzw((Object)this.mContext), zzn.zzw((Object)jSONObject), string)));
    }

    @NonNull
    public final zzecv zza(Uri uri, JSONObject jSONObject) throws RemoteException {
        return this.zze(new zzecv(this.zzmxq.zza(uri, zzn.zzw((Object)this.mContext), zzn.zzw((Object)jSONObject))));
    }

    @Nullable
    public final String zzcbl() {
        try {
            return this.zzmxq.zzcbl();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getBackendAuthority failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @Nullable
    public final String zzu(Uri uri) {
        try {
            return this.zzmxq.zzu(uri);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getDefaultURL failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }
}

