/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzecq;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class zzecv {
    private zzecq zzmxr;
    private Exception zzkgm;
    private int zzmxs;
    private Exception zzmxt;

    public zzecv(@NonNull zzecq zzecq2) {
        this.zzmxr = zzecq2;
    }

    public final void zzbo(String string, String string2) {
        try {
            this.zzmxr.zzbo(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzrh(String string) {
        try {
            return this.zzmxr.zzrh(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzecv zzecv2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzecv2.zzmxs = -2;
                zzecv2.zzmxt = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzmxr.zzrf(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzmxs = 0;
            this.zzmxt = null;
            this.zzmxr.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzrg(@Nullable String string) {
        try {
            this.zzmxr.zzrg(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzcbe() {
        try {
            if (this.zzmxr != null) {
                this.zzmxr.zzcbe();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzx((IObjectWrapper)this.zzmxr.zzcbf());
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzcbm() throws RemoteException {
        return (JSONObject)zzn.zzx((IObjectWrapper)this.zzmxr.zzcbg());
    }

    @Nullable
    public final String zzcbh() {
        try {
            this.zzmxr.zzcbh();
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzmxt != null) {
                return this.zzmxt;
            }
            if (this.zzkgm != null) {
                return this.zzkgm;
            }
            return (Exception)zzn.zzx((IObjectWrapper)this.zzmxr.zzcbi());
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzmxs != 0) {
                return this.zzmxs;
            }
            return this.zzmxr.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzcbj() {
        try {
            if (this.zzmxs == -2 || this.zzmxt != null) {
                return false;
            }
            return this.zzmxr.zzcbj();
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzcbj() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzcbk() {
        try {
            return this.zzmxr.zzcbk();
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

