/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzeck;
import com.google.android.gms.internal.zzecu;
import com.google.android.gms.internal.zzecv;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzmtm;
    private long zzmtn;
    private StorageReference zzmtj;
    private zzeck zzmtl;
    private long zzggc = -1L;
    private String zzmto = null;
    private volatile Exception zzkgm = null;
    private long zzmtp = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzmtj = storageReference;
        this.zzmtm = uri;
        this.zzmtl = new zzeck(this.zzmtj.getStorage().getApp(), this.zzmtj.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzggc;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzmtj;
    }

    @Override
    protected void schedule() {
        zzu.zzr(this.zzbjf());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzkgm = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzecv zzecv2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzecv2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzmtm.getPath());
            if (!file.exists()) {
                if (this.zzmtp > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzmtp > 0L) {
                object = file.getAbsolutePath();
                long l = this.zzmtp;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzmtn += (long)n;
                    if (this.zzkgm != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzkgm);
                        this.zzkgm = null;
                        bl = false;
                    }
                    if (this.zzk(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzkgm = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzkgm != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        do {
            Object object;
            zzecv zzecv2;
            this.zzmtn = 0L;
            this.zzkgm = null;
            this.zzmtl.reset();
            try {
                zzecv2 = zzecu.zzg(this.zzmtj.getStorage().getApp()).zza(this.zzmtj.zzcao(), this.zzmtp);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzkgm = remoteException;
                this.zzk(64, false);
                return;
            }
            this.zzmtl.zza(zzecv2, false);
            this.mResultCode = zzecv2.getResultCode();
            this.zzkgm = zzecv2.getException() != null ? zzecv2.getException() : this.zzkgm;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzkgm == null && this.zzcaq() == 4;
            if (bl) {
                this.zzggc = zzecv2.zzcbk();
                object = zzecv2.zzrh("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzmto != null && !this.zzmto.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzmtp = 0L;
                    this.zzmto = null;
                    zzecv2.zzcbe();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zzmto = object;
                try {
                    bl = this.zza(zzecv2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzkgm = iOException;
                }
            }
            zzecv2.zzcbe();
            if (bl && this.zzkgm == null && this.zzcaq() == 4) {
                this.zzk(128, false);
                return;
            }
            object = new File(this.zzmtm.getPath());
            this.zzmtp = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcaq() == 8) {
                this.zzk(16, false);
                return;
            }
            if (this.zzcaq() != 32) continue;
            if (!this.zzk(256, false)) {
                int n2 = this.zzcaq();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzmtn > 0L);
        this.zzk(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzmtl.cancel();
        this.zzkgm = StorageException.fromErrorStatus(Status.zzfhy);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcak() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzkgm, fileDownloadTask.mResultCode)), fileDownloadTask.zzmtn + fileDownloadTask.zzmtp);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmtn;
        private /* synthetic */ FileDownloadTask zzmtq;

        TaskSnapshot(@Nullable FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzmtq = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzmtn = l;
        }

        public long getBytesTransferred() {
            return this.zzmtn;
        }

        public long getTotalByteCount() {
            return this.zzmtq.getTotalBytes();
        }
    }
}

