/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzecl;
import com.google.android.gms.internal.zzecp;
import com.google.android.gms.internal.zzecu;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzd;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzmub = null;
    private StorageReference zzmtj = null;
    private String zzmuc = null;
    private String zzmud = null;
    private zza<String> zzmue = zza.zzbs("");
    private String zzmuf = null;
    private String zzmug = null;
    private String zzmuh = null;
    private long zzmui;
    private String zzmuj = null;
    private zza<String> zzmuk = zza.zzbs("");
    private zza<String> zzmul = zza.zzbs("");
    private zza<String> zzmum = zza.zzbs("");
    private zza<String> zzmun = zza.zzbs("");
    private zza<Map<String, String>> zzmuo = zza.zzbs(Collections.emptyMap());
    private String[] zzmup = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbp.zzu((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzmub = storageMetadata.zzmub;
        this.zzmtj = storageMetadata.zzmtj;
        this.zzmuc = storageMetadata.zzmuc;
        this.zzmue = storageMetadata.zzmue;
        this.zzmuk = storageMetadata.zzmuk;
        this.zzmul = storageMetadata.zzmul;
        this.zzmum = storageMetadata.zzmum;
        this.zzmun = storageMetadata.zzmun;
        this.zzmuo = storageMetadata.zzmuo;
        this.zzmup = storageMetadata.zzmup;
        if (bl) {
            this.zzmuj = storageMetadata.zzmuj;
            this.zzmui = storageMetadata.zzmui;
            this.zzmuh = storageMetadata.zzmuh;
            this.zzmug = storageMetadata.zzmug;
            this.zzmuf = storageMetadata.zzmuf;
            this.zzmud = storageMetadata.zzmud;
        }
    }

    public String getContentType() {
        return this.zzmue.getValue();
    }

    public String getCustomMetadata(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzmuo.getValue().get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        return this.zzmuo.getValue().keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzmuc;
    }

    @Nullable
    public String getGeneration() {
        return this.zzmud;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzmuf;
    }

    public long getCreationTimeMillis() {
        return zzecp.zzre(this.zzmug);
    }

    public long getUpdatedTimeMillis() {
        return zzecp.zzre(this.zzmuh);
    }

    public long getSizeBytes() {
        return this.zzmui;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzmuj;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzmup != null && this.zzmtj != null) {
            try {
                String string = zzecu.zzg(this.zzmtj.getStorage().getApp()).zzu(this.zzmtj.zzcao());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzmup;
                    int n = this.zzmup.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzmuk.getValue();
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzmul.getValue();
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzmum.getValue();
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzmun.getValue();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzmtj == null && this.zzmub != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzecl.zzrb((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzmub);
        }
        return this.zzmtj;
    }

    @NonNull
    final JSONObject zzcal() throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.zzmue.zzcam()) {
            hashMap.put("contentType", this.getContentType());
        }
        if (this.zzmuo.zzcam()) {
            hashMap.put("metadata", (String)new JSONObject(this.zzmuo.getValue()));
        }
        if (this.zzmuk.zzcam()) {
            hashMap.put("cacheControl", this.getCacheControl());
        }
        if (this.zzmul.zzcam()) {
            hashMap.put("contentDisposition", this.getContentDisposition());
        }
        if (this.zzmum.zzcam()) {
            hashMap.put("contentEncoding", this.getContentEncoding());
        }
        if (this.zzmun.zzcam()) {
            hashMap.put("contentLanguage", this.getContentLanguage());
        }
        return new JSONObject(hashMap);
    }

    private final void zzra(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzmup = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzd zzd2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzmuq;
        private boolean zzmur;

        public Builder() {
            this.zzmuq = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzmuq = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzmuq.zzmtj = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzmuq = new StorageMetadata();
            if (jSONObject != null) {
                this.zzt(jSONObject);
                this.zzmur = true;
            }
        }

        @Nullable
        private static String zze(JSONObject jSONObject, String string) throws JSONException {
            if (jSONObject.has(string) && !jSONObject.isNull(string)) {
                return jSONObject.getString(string);
            }
            return null;
        }

        private final void zzt(JSONObject jSONObject) throws JSONException {
            String string;
            this.zzmuq.zzmud = jSONObject.optString("generation");
            this.zzmuq.mPath = jSONObject.optString("name");
            this.zzmuq.zzmuc = jSONObject.optString("bucket");
            this.zzmuq.zzmuf = jSONObject.optString("metageneration");
            this.zzmuq.zzmug = jSONObject.optString("timeCreated");
            this.zzmuq.zzmuh = jSONObject.optString("updated");
            this.zzmuq.zzmui = jSONObject.optLong("size");
            this.zzmuq.zzmuj = jSONObject.optString("md5Hash");
            this.zzmuq.zzra(jSONObject.optString("downloadTokens"));
            if (jSONObject.has("metadata") && !jSONObject.isNull("metadata")) {
                string = jSONObject.getJSONObject("metadata");
                Iterator iterator = string.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.setCustomMetadata(string2, string.getString(string2));
                }
            }
            if ((string = Builder.zze(jSONObject, "contentType")) != null) {
                this.setContentType(string);
            }
            if ((string = Builder.zze(jSONObject, "cacheControl")) != null) {
                this.setCacheControl(string);
            }
            if ((string = Builder.zze(jSONObject, "contentDisposition")) != null) {
                this.setContentDisposition(string);
            }
            if ((string = Builder.zze(jSONObject, "contentEncoding")) != null) {
                this.setContentEncoding(string);
            }
            if ((string = Builder.zze(jSONObject, "contentLanguage")) != null) {
                this.setContentLanguage(string);
            }
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzmuq, this.zzmur, null);
        }

        public Builder setContentLanguage(@Nullable String string) {
            this.zzmuq.zzmun = zza.zzbt(string);
            return this;
        }

        public Builder setContentEncoding(@Nullable String string) {
            this.zzmuq.zzmum = zza.zzbt(string);
            return this;
        }

        public Builder setContentDisposition(@Nullable String string) {
            this.zzmuq.zzmul = zza.zzbt(string);
            return this;
        }

        public Builder setCacheControl(@Nullable String string) {
            this.zzmuq.zzmuk = zza.zzbt(string);
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (!this.zzmuq.zzmuo.zzcam()) {
                this.zzmuq.zzmuo = zza.zzbt(new HashMap());
            }
            ((Map)this.zzmuq.zzmuo.getValue()).put(string, string2);
            return this;
        }

        public Builder setContentType(@Nullable String string) {
            this.zzmuq.zzmue = zza.zzbt(string);
            return this;
        }
    }

    static final class zza<T> {
        private final boolean zzmus;
        @Nullable
        private final T value;

        private zza(@Nullable T t, boolean bl) {
            this.zzmus = bl;
            this.value = t;
        }

        static <T> zza<T> zzbs(T t) {
            return new zza<T>(t, false);
        }

        static <T> zza<T> zzbt(@Nullable T t) {
            return new zza<T>(t, true);
        }

        final boolean zzcam() {
            return this.zzmus;
        }

        @Nullable
        final T getValue() {
            return this.value;
        }
    }
}

