/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzecl;
import com.google.android.gms.internal.zzecu;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StreamDownloadTask;
import com.google.firebase.storage.UploadTask;
import com.google.firebase.storage.zzac;
import com.google.firebase.storage.zzb;
import com.google.firebase.storage.zzc;
import com.google.firebase.storage.zze;
import com.google.firebase.storage.zzf;
import com.google.firebase.storage.zzg;
import com.google.firebase.storage.zzh;
import com.google.firebase.storage.zzi;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class StorageReference {
    private final Uri zzmut;
    private final FirebaseStorage zzmuu;

    StorageReference(@NonNull Uri uri, @NonNull FirebaseStorage firebaseStorage) {
        zzbp.zzb((uri != null ? 1 : 0) != 0, (Object)"storageUri cannot be null");
        zzbp.zzb((firebaseStorage != null ? 1 : 0) != 0, (Object)"FirebaseApp cannot be null");
        this.zzmut = uri;
        this.zzmuu = firebaseStorage;
    }

    @NonNull
    public StorageReference child(@NonNull String string) {
        Uri uri;
        zzbp.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"childName cannot be null or empty");
        string = zzecl.zzrd((String)string);
        try {
            uri = this.zzmut.buildUpon().appendEncodedPath(zzecl.zzrb((String)string)).build();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = String.valueOf(string);
            Log.e((String)"StorageReference", (String)(string2.length() != 0 ? "Unable to create a valid default Uri. ".concat(string2) : new String("Unable to create a valid default Uri. ")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("childName");
        }
        return new StorageReference(uri, this.zzmuu);
    }

    @Nullable
    public StorageReference getParent() {
        String string = this.zzmut.getPath();
        if (TextUtils.isEmpty((CharSequence)string) || string.equals("/")) {
            return null;
        }
        int n = string.lastIndexOf(47);
        string = n == -1 ? "/" : string.substring(0, n);
        Uri uri = this.zzmut.buildUpon().path(string).build();
        return new StorageReference(uri, this.zzmuu);
    }

    @NonNull
    public StorageReference getRoot() {
        Uri uri = this.zzmut.buildUpon().path("").build();
        return new StorageReference(uri, this.zzmuu);
    }

    @NonNull
    public String getName() {
        String string = this.zzmut.getPath();
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @NonNull
    public String getPath() {
        return this.zzmut.getPath();
    }

    @NonNull
    public String getBucket() {
        return this.zzmut.getAuthority();
    }

    @NonNull
    public FirebaseStorage getStorage() {
        return this.zzmuu;
    }

    @NonNull
    final zzecu zzcan() throws RemoteException {
        return zzecu.zzg(this.getStorage().getApp());
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray) {
        zzbp.zzb((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, byArray);
        uploadTask.zzcap();
        return uploadTask;
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray, @NonNull StorageMetadata storageMetadata) {
        zzbp.zzb((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        zzbp.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, byArray);
        uploadTask.zzcap();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri) {
        zzbp.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, uri, null);
        uploadTask.zzcap();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @NonNull StorageMetadata storageMetadata) {
        zzbp.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzbp.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, null);
        uploadTask.zzcap();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @Nullable StorageMetadata storageMetadata, @Nullable Uri uri2) {
        zzbp.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzbp.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, uri2);
        uploadTask.zzcap();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream) {
        zzbp.zzb((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, inputStream);
        uploadTask.zzcap();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream, @NonNull StorageMetadata storageMetadata) {
        zzbp.zzb((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        zzbp.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, inputStream);
        uploadTask.zzcap();
        return uploadTask;
    }

    @NonNull
    public List<UploadTask> getActiveUploadTasks() {
        return zzt.zzcau().zza(this);
    }

    @NonNull
    public List<FileDownloadTask> getActiveDownloadTasks() {
        return zzt.zzcau().zzb(this);
    }

    @NonNull
    public Task<StorageMetadata> getMetadata() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzu.zzp(new zzc(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Uri> getDownloadUrl() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Task<StorageMetadata> task = this.getMetadata();
        task.addOnSuccessListener((OnSuccessListener)new zze(this, taskCompletionSource));
        task.addOnFailureListener((OnFailureListener)new zzf(this, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<StorageMetadata> updateMetadata(@NonNull StorageMetadata storageMetadata) {
        zzbp.zzu((Object)storageMetadata);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzu.zzp(new zzac(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource, storageMetadata));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<byte[]> getBytes(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        ((StorageTask)streamDownloadTask.zza(new zzi(this, l, taskCompletionSource)).addOnSuccessListener(new zzh(this, taskCompletionSource))).addOnFailureListener(new zzg(this, taskCompletionSource));
        streamDownloadTask.zzcap();
        return taskCompletionSource.getTask();
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull Uri uri) {
        FileDownloadTask fileDownloadTask = new FileDownloadTask(this, uri);
        fileDownloadTask.zzcap();
        return fileDownloadTask;
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull File file) {
        return this.getFile(Uri.fromFile((File)file));
    }

    @NonNull
    public StreamDownloadTask getStream() {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zzcap();
        return streamDownloadTask;
    }

    @NonNull
    public StreamDownloadTask getStream(@NonNull StreamDownloadTask.StreamProcessor streamProcessor) {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zza(streamProcessor);
        streamDownloadTask.zzcap();
        return streamDownloadTask;
    }

    public Task<Void> delete() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzu.zzp(new zzb(this, (TaskCompletionSource<Void>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    final Uri zzcao() {
        return this.zzmut;
    }

    public String toString() {
        String string = this.zzmut.getAuthority();
        String string2 = this.zzmut.getEncodedPath();
        return new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append("gs://").append(string).append(string2).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StorageReference)) {
            return false;
        }
        return ((StorageReference)object).toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

