/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.CancellableTask;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzj;
import com.google.firebase.storage.zzk;
import com.google.firebase.storage.zzl;
import com.google.firebase.storage.zzm;
import com.google.firebase.storage.zzn;
import com.google.firebase.storage.zzo;
import com.google.firebase.storage.zzp;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzx;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zzmuy = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzmuz = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    private zzx<OnSuccessListener<? super TResult>, TResult> zzmva = new zzx(this, 128, new zzj(this));
    @VisibleForTesting
    private zzx<OnFailureListener, TResult> zzmvb = new zzx(this, 320, new zzk(this));
    @VisibleForTesting
    private zzx<OnCompleteListener<TResult>, TResult> zzmvc = new zzx(this, 448, new zzl(this));
    @VisibleForTesting
    private zzx<OnProgressListener<? super TResult>, TResult> zzmvd = new zzx(this, -465, new zzm(this));
    @VisibleForTesting
    private zzx<OnPausedListener<? super TResult>, TResult> zzmve = new zzx(this, 16, new zzn(this));
    private volatile int zzcfi = 1;
    private TResult zzmvf;

    protected StorageTask() {
    }

    @VisibleForTesting
    final boolean zzcap() {
        if (this.zzk(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzk(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zza(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.zza(new int[]{256, 32}, true);
    }

    public boolean isComplete() {
        return (this.zzcfi & 0x80) != 0 || (this.zzcfi & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzcfi & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzcfi == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzcfi & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzcfi & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzcas() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzcas().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzcas();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzcas() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzcas().getError())) {
            throw (Throwable)clazz.cast(this.zzcas().getError());
        }
        Exception exception = this.zzcas().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzcas();
    }

    @Nullable
    public Exception getException() {
        if (this.zzcas() == null) {
            return null;
        }
        return this.zzcas().getError();
    }

    public TResult getSnapshot() {
        return this.zzcar();
    }

    @VisibleForTesting
    final int zzcaq() {
        return this.zzcfi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    final TResult zzcar() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzcak();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzcak();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zza(int[] nArray, boolean bl) {
        HashMap<Integer, HashSet<Integer>> hashMap = bl ? zzmuy : zzmuz;
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = object2[i];
                HashSet<Integer> hashSet = hashMap.get(this.zzcfi);
                if (hashSet == null || !hashSet.contains(n2)) continue;
                this.zzcfi = n2;
                switch (this.zzcfi) {
                    case 2: {
                        zzt.zzcau().zzb(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzmva.zzcay();
                this.zzmvb.zzcay();
                this.zzmvc.zzcay();
                this.zzmve.zzcay();
                this.zzmvd.zzcay();
                if (Log.isLoggable((String)"StorageTask", (int)3)) {
                    String string = StorageTask.zzge(n2);
                    String string2 = StorageTask.zzge(this.zzcfi);
                    Log.d((String)"StorageTask", (String)new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string2).length()).append("changed internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
                }
                return true;
            }
            object2 = StorageTask.zzf(nArray);
            String string = StorageTask.zzge(this.zzcfi);
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(object2).length() + String.valueOf(string).length()).append("unable to change internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append(string).toString());
            return false;
        }
    }

    @VisibleForTesting
    final boolean zzk(int n, boolean bl) {
        return this.zza(new int[]{n}, bl);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private final TResult zzcas() {
        if (this.zzmvf != null) {
            return this.zzmvf;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzmvf == null) {
            this.zzmvf = this.zzcar();
        }
        return this.zzmvf;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        this.zzmve.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        zzbp.zzu((Object)executor);
        this.zzmve.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        zzbp.zzu((Object)activity);
        this.zzmve.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        this.zzmve.zzbu(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        this.zzmvd.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        zzbp.zzu((Object)executor);
        this.zzmvd.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        zzbp.zzu((Object)activity);
        this.zzmvd.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        this.zzmvd.zzbu(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu(onSuccessListener);
        this.zzmva.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu((Object)executor);
        zzbp.zzu(onSuccessListener);
        this.zzmva.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu((Object)activity);
        zzbp.zzu(onSuccessListener);
        this.zzmva.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu(onSuccessListener);
        this.zzmva.zzbu(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        this.zzmvb.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        zzbp.zzu((Object)executor);
        this.zzmvb.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        zzbp.zzu((Object)activity);
        this.zzmvb.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        this.zzmvb.zzbu(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        this.zzmvc.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        zzbp.zzu((Object)executor);
        this.zzmvc.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        zzbp.zzu((Object)activity);
        this.zzmvc.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        this.zzmvc.zzbu(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzmvc.zza(null, executor, new zzo(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzmvc.zza(null, executor, new zzp(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    final Runnable zzbjf() {
        return new zzs(this);
    }

    private final void zzcat() {
        if (!(this.isComplete() || ((ControllableTask)this).isPaused() || this.zzcfi == 2 || this.zzk(256, false))) {
            this.zzk(64, false);
        }
    }

    private static String zzf(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            stringBuilder.append(StorageTask.zzge(n2)).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static String zzge(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void zza(StorageTask storageTask) {
        storageTask.zzcat();
    }

    static {
        zzmuy.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zzmuy.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzmuy.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzmuy.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzmuy.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzmuz.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zzmuz.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzmuz.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzmuz.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzmuz.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception zzmvj;
        private /* synthetic */ StorageTask zzmvg;

        public SnapshotBase(@Nullable StorageTask storageTask, Exception exception) {
            this.zzmvg = storageTask;
            if (exception == null) {
                if (((CancellableTask)storageTask).isCanceled()) {
                    this.zzmvj = StorageException.fromErrorStatus(Status.zzfhy);
                    return;
                }
                if (storageTask.zzcaq() == 64) {
                    this.zzmvj = StorageException.fromErrorStatus(Status.zzfhw);
                    return;
                }
                this.zzmvj = null;
                return;
            }
            this.zzmvj = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return this.zzmvg;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zzmvj;
        }
    }

    public static interface ProvideError {
        public Exception getError();
    }
}

