/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzecj;
import com.google.android.gms.internal.zzeck;
import com.google.android.gms.internal.zzecp;
import com.google.android.gms.internal.zzecv;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzad;
import com.google.firebase.storage.zzu;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzmtj;
    private final Uri mUri;
    private final long zzmwr;
    private final zzecj zzmws;
    private final AtomicLong zzmwt;
    private int zzmwu;
    private zzeck zzmtl;
    private boolean zzmwv;
    private volatile StorageMetadata zzmuq;
    private volatile Uri zzmww;
    private volatile Exception zzkgm;
    private volatile Exception zzmwx;
    private volatile int mResultCode;
    private volatile String zzmwy;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzmwt = new AtomicLong(0L);
        this.zzmwu = 262144;
        this.zzmww = null;
        this.zzkgm = null;
        this.zzmwx = null;
        this.mResultCode = 0;
        zzbp.zzu((Object)storageReference);
        zzbp.zzu((Object)byArray);
        this.zzmwr = byArray.length;
        this.zzmtj = storageReference;
        this.zzmuq = storageMetadata;
        this.mUri = null;
        this.zzmws = new zzecj(new ByteArrayInputStream(byArray), 262144);
        this.zzmwv = true;
        this.zzmtl = new zzeck(this.zzmtj.getStorage().getApp(), this.zzmtj.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzmwt = new AtomicLong(0L);
            this.zzmwu = 262144;
            this.zzmww = null;
            this.zzkgm = null;
            this.zzmwx = null;
            this.mResultCode = 0;
            zzbp.zzu((Object)storageReference);
            zzbp.zzu((Object)uri);
            this.zzmtj = storageReference;
            this.zzmuq = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzmtl = new zzeck(this.zzmtj.getStorage().getApp(), this.zzmtj.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzmtj.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzkgm = fileNotFoundException;
            }
        }
        this.zzmwr = l;
        this.zzmws = new zzecj(inputStream, 262144);
        this.zzmwv = true;
        this.zzmww = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzmwt = new AtomicLong(0L);
        this.zzmwu = 262144;
        this.zzmww = null;
        this.zzkgm = null;
        this.zzmwx = null;
        this.mResultCode = 0;
        zzbp.zzu((Object)storageReference);
        zzbp.zzu((Object)inputStream);
        this.zzmwr = -1L;
        this.zzmtj = storageReference;
        this.zzmuq = storageMetadata;
        this.zzmws = new zzecj(inputStream, 262144);
        this.zzmwv = false;
        this.mUri = null;
        this.zzmtl = new zzeck(this.zzmtj.getStorage().getApp(), this.zzmtj.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzmtj;
    }

    final long getTotalByteCount() {
        return this.zzmwr;
    }

    @Override
    protected void schedule() {
        zzu.zzq(this.zzbjf());
    }

    @Override
    final void run() {
        zzecv zzecv2;
        UploadTask uploadTask;
        block24: {
            this.zzmtl.reset();
            if (!this.zzk(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzmtj.getParent() == null) {
                this.zzkgm = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzkgm != null) {
                return;
            }
            if (this.zzmww == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzmuq != null) {
                    string2 = uploadTask.zzmuq.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzmtj.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    zzecv2 = uploadTask.zzmtj.zzcan().zza(uploadTask.zzmtj.zzcao(), uploadTask.zzmuq != null ? uploadTask.zzmuq.zzcal() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzkgm = throwable;
                    break block24;
                }
                if (uploadTask.zzc(zzecv2) && !TextUtils.isEmpty((CharSequence)(string = zzecv2.zzrh("X-Goog-Upload-URL")))) {
                    uploadTask.zzmww = Uri.parse((String)string);
                }
            } else {
                this.zzcn(false);
            }
        }
        boolean bl = this.zzcaz();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzmws.zzgg(uploadTask.zzmwu);
                    int n = Math.min(uploadTask.zzmwu, uploadTask.zzmws.available());
                    try {
                        zzecv2 = uploadTask.zzmtj.zzcan().zza(uploadTask.zzmtj.zzcao(), uploadTask.zzmww.toString(), uploadTask.zzmws.zzcbd(), uploadTask.zzmwt.get(), n, uploadTask.zzmws.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzkgm = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(zzecv2)) {
                        int n2 = uploadTask.zzmwu = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzmwt.getAndAdd(n);
                    if (!uploadTask.zzmws.isFinished()) {
                        uploadTask.zzmws.zzgf(n);
                        if (uploadTask.zzmwu < 0x2000000) {
                            uploadTask.zzmwu <<= 1;
                            int n3 = uploadTask.zzmwu;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzmuq = new StorageMetadata.Builder(zzecv2.zzcbm(), uploadTask.zzmtj).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(zzecv2.zzcbh());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzkgm = throwable;
                        break block25;
                    }
                    uploadTask.zzk(4, false);
                    uploadTask.zzk(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzkgm = iOException;
                }
            }
            if (!(bl = this.zzcaz())) continue;
            this.zzk(4, false);
        }
        if (this.zzmwv && this.zzcaq() != 16) {
            try {
                this.zzmws.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzkgm = null;
        this.zzmwx = null;
        this.mResultCode = 0;
        this.zzmwy = null;
    }

    private final boolean zzcaz() {
        if (this.zzcaq() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzkgm = new InterruptedException();
            this.zzk(64, false);
            return false;
        }
        if (this.zzcaq() == 32) {
            this.zzk(256, false);
            return false;
        }
        if (this.zzcaq() == 8) {
            this.zzk(16, false);
            return false;
        }
        if (!this.zzcba()) {
            return false;
        }
        if (this.zzmww == null) {
            if (this.zzkgm == null) {
                this.zzkgm = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzk(64, false);
            return false;
        }
        if (this.zzkgm != null) {
            this.zzk(64, false);
            return false;
        }
        if ((this.zzmwx != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzcn(true)) {
            if (this.zzcba()) {
                this.zzk(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzcba() {
        if ("final".equals(this.zzmwy)) {
            if (this.zzkgm == null) {
                this.zzkgm = new IOException("The server has terminated the upload session");
            }
            this.zzk(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzcn(boolean bl) {
        zzecv zzecv2;
        try {
            zzecv2 = this.zzmtj.zzcan().zzb(this.zzmtj.zzcao(), this.zzmww.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzkgm = remoteException;
            return false;
        }
        if ("final".equals(this.zzmwy)) {
            return false;
        }
        if (bl ? !this.zzc(zzecv2) : !this.zzb(zzecv2)) {
            return false;
        }
        if ("final".equals(zzecv2.zzrh("X-Goog-Upload-Status"))) {
            this.zzkgm = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzecv2.zzrh("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzmwt.get();
        if (l2 > l) {
            this.zzkgm = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzmws.zzgf((int)(l - l2)) != l - l2) {
                    this.zzkgm = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzmwt.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzkgm = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzkgm = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(zzecv zzecv2) {
        zzecv2.zze(zzecp.zzf(this.zzmtj.getStorage().getApp()), this.zzmtj.getStorage().getApp().getApplicationContext());
        return this.zzd(zzecv2);
    }

    private final boolean zzc(zzecv zzecv2) {
        zzecv zzecv3 = zzecv2;
        this.zzmtl.zza(zzecv3, true);
        return this.zzd(zzecv2);
    }

    private final boolean zzd(zzecv zzecv2) {
        int n = zzecv2.getResultCode();
        this.mResultCode = zzeck.zzgi(n) ? -2 : n;
        this.zzmwx = zzecv2.getException();
        this.zzmwy = zzecv2.zzrh("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzmwx == null;
    }

    @Override
    protected void onCanceled() {
        this.zzmtl.cancel();
        zzecv zzecv2 = null;
        if (this.zzmww != null) {
            try {
                zzecv2 = this.zzmtj.zzcan().zza(this.zzmtj.zzcao(), this.zzmww.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzecv2 != null) {
            zzecv zzecv3 = zzecv2;
            zzu.zzp(new zzad(this, zzecv3));
        }
        this.zzkgm = StorageException.fromErrorStatus(Status.zzfhy);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcak() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzkgm != null ? uploadTask.zzkgm : uploadTask.zzmwx;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzmwt.get(), uploadTask.zzmww, uploadTask.zzmuq);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzmtj;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmxb;
        private final Uri zzmww;
        private final StorageMetadata zzmuq;
        private /* synthetic */ UploadTask zzmxa;

        TaskSnapshot(@Nullable UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzmxa = uploadTask;
            super(uploadTask, exception);
            this.zzmxb = l;
            this.zzmww = uri;
            this.zzmuq = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzmxb;
        }

        public long getTotalByteCount() {
            return this.zzmxa.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzmww;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzmuq;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

