/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public final class zzemp {
    private static final Runtime zznrg = Runtime.getRuntime();
    private final InputStream zznrh;
    private byte[] buffer;
    private int zznri;
    private boolean zznrj;
    private boolean zznrk;

    public zzemp(InputStream inputStream, int n) {
        this.zznrh = inputStream;
        this.buffer = new byte[262144];
        this.zznri = 0;
        this.zznrk = true;
        this.zznrj = false;
    }

    public final int available() {
        return this.zznri;
    }

    public final byte[] zzcip() {
        return this.buffer;
    }

    public final int zzhr(int n) throws IOException {
        int n2;
        if (n <= this.zznri) {
            this.zznri -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zznri);
            n2 = n;
        } else {
            n2 = this.zznri = 0;
            while (n2 < n) {
                long l = this.zznrh.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zznrh.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public final int zzhs(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzht(n));
        }
        while (this.zznri < n) {
            int n2 = this.zznrh.read(this.buffer, this.zznri, n - this.zznri);
            if (n2 == -1) {
                this.zznrj = true;
                break;
            }
            this.zznri += n2;
        }
        return this.zznri;
    }

    private final int zzht(int n) {
        int n2 = Math.max(this.buffer.length << 1, n);
        if (this.zznrk && (long)(n2 + 262144) < zznrg.freeMemory()) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zznri);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zznrk = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public final boolean isFinished() {
        return this.zznrj;
    }

    public final void close() throws IOException {
        this.zznrh.close();
    }
}

