/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzena;
import com.google.android.gms.internal.zzenb;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zznnm;
    private long zznnn;
    private StorageReference zznnj;
    private zzemq zznnl;
    private long zzggd = -1L;
    private String zznno = null;
    private volatile Exception zzkgm = null;
    private long zznnp = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zznnj = storageReference;
        this.zznnm = uri;
        this.zznnl = new zzemq(this.zznnj.getStorage().getApp(), this.zznnj.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzggd;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zznnj;
    }

    @Override
    protected void schedule() {
        zzu.zzs(this.zzbje());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzkgm = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzenb zzenb2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzenb2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zznnm.getPath());
            if (!file.exists()) {
                if (this.zznnp > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zznnp > 0L) {
                object = file.getAbsolutePath();
                long l = this.zznnp;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zznnn += (long)n;
                    if (this.zzkgm != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzkgm);
                        this.zzkgm = null;
                        bl = false;
                    }
                    if (this.zzk(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzkgm = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzkgm != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        do {
            Object object;
            zzenb zzenb2;
            this.zznnn = 0L;
            this.zzkgm = null;
            this.zznnl.reset();
            try {
                zzenb2 = zzena.zzh(this.zznnj.getStorage().getApp()).zza(this.zznnj.zzcia(), this.zznnp);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzkgm = remoteException;
                this.zzk(64, false);
                return;
            }
            this.zznnl.zza(zzenb2, false);
            this.mResultCode = zzenb2.getResultCode();
            this.zzkgm = zzenb2.getException() != null ? zzenb2.getException() : this.zzkgm;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzkgm == null && this.zzcic() == 4;
            if (bl) {
                this.zzggd = zzenb2.zzciw();
                object = zzenb2.zzsd("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zznno != null && !this.zznno.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zznnp = 0L;
                    this.zznno = null;
                    zzenb2.zzciq();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zznno = object;
                try {
                    bl = this.zza(zzenb2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzkgm = iOException;
                }
            }
            zzenb2.zzciq();
            if (bl && this.zzkgm == null && this.zzcic() == 4) {
                this.zzk(128, false);
                return;
            }
            object = new File(this.zznnm.getPath());
            this.zznnp = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcic() == 8) {
                this.zzk(16, false);
                return;
            }
            if (this.zzcic() != 32) continue;
            if (!this.zzk(256, false)) {
                int n2 = this.zzcic();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zznnn > 0L);
        this.zzk(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zznnl.cancel();
        this.zzkgm = StorageException.fromErrorStatus(Status.zzfhz);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzchw() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzkgm, fileDownloadTask.mResultCode)), fileDownloadTask.zznnn + fileDownloadTask.zznnp);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zznnn;
        private /* synthetic */ FileDownloadTask zznnq;

        TaskSnapshot(@Nullable FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zznnq = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zznnn = l;
        }

        public long getBytesTransferred() {
            return this.zznnn;
        }

        public long getTotalByteCount() {
            return this.zznnq.getTotalBytes();
        }
    }
}

