/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzemv;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class FirebaseStorage {
    private static final Map<String, Map<String, FirebaseStorage>> zznnr = new HashMap<String, Map<String, FirebaseStorage>>();
    @NonNull
    private final FirebaseApp zznfk;
    @Nullable
    private final String zznns;
    private long zznnt = 600000L;
    private long zznnu = 600000L;
    private long zznnv = 120000L;

    private FirebaseStorage(@Nullable String string, @NonNull FirebaseApp firebaseApp) {
        this.zznns = string;
        this.zznfk = firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FirebaseStorage zza(@NonNull FirebaseApp firebaseApp, @Nullable Uri uri) {
        String string;
        String string2 = string = uri != null ? uri.getHost() : null;
        if (uri != null && !TextUtils.isEmpty((CharSequence)uri.getPath())) {
            throw new IllegalArgumentException("The storage Uri cannot contain a path element.");
        }
        Map<String, Map<String, FirebaseStorage>> map = zznnr;
        synchronized (map) {
            FirebaseStorage firebaseStorage;
            Map<String, FirebaseStorage> map2 = zznnr.get(firebaseApp.getName());
            if (map2 == null) {
                map2 = new HashMap<String, FirebaseStorage>();
                zznnr.put(firebaseApp.getName(), map2);
            }
            if ((firebaseStorage = map2.get(string)) == null) {
                firebaseStorage = new FirebaseStorage(string, firebaseApp);
                map2.put(string, firebaseStorage);
            }
            return firebaseStorage;
        }
    }

    @NonNull
    public static FirebaseStorage getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        zzbp.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        return FirebaseStorage.getInstance(firebaseApp);
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        zzbp.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        return FirebaseStorage.getInstance(firebaseApp, string);
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull FirebaseApp firebaseApp) {
        zzbp.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        String string = firebaseApp.getOptions().getStorageBucket();
        if (string == null) {
            return FirebaseStorage.zza(firebaseApp, null);
        }
        try {
            String string2 = String.valueOf(firebaseApp.getOptions().getStorageBucket());
            return FirebaseStorage.zza(firebaseApp, zzemv.zzf(firebaseApp, string2.length() != 0 ? "gs://".concat(string2) : new String("gs://")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = String.valueOf(string);
            Log.e((String)"FirebaseStorage", (String)(string3.length() != 0 ? "Unable to parse bucket:".concat(string3) : new String("Unable to parse bucket:")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("The storage Uri could not be parsed.");
        }
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        zzbp.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        if (!string.toLowerCase().startsWith("gs://")) {
            throw new IllegalArgumentException("Please use a gs:// URL for your Firebase Storage bucket.");
        }
        try {
            return FirebaseStorage.zza(firebaseApp, zzemv.zzf(firebaseApp, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = String.valueOf(string);
            Log.e((String)"FirebaseStorage", (String)(string2.length() != 0 ? "Unable to parse url:".concat(string2) : new String("Unable to parse url:")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("The storage Uri could not be parsed.");
        }
    }

    public long getMaxDownloadRetryTimeMillis() {
        return this.zznnu;
    }

    public void setMaxDownloadRetryTimeMillis(long l) {
        this.zznnu = l;
    }

    public long getMaxUploadRetryTimeMillis() {
        return this.zznnt;
    }

    public void setMaxUploadRetryTimeMillis(long l) {
        this.zznnt = l;
    }

    public long getMaxOperationRetryTimeMillis() {
        return this.zznnv;
    }

    public void setMaxOperationRetryTimeMillis(long l) {
        this.zznnv = l;
    }

    @NonNull
    public StorageReference getReference() {
        if (TextUtils.isEmpty((CharSequence)this.zznns)) {
            throw new IllegalStateException("FirebaseApp was not initialized with a bucket name.");
        }
        Uri uri = new Uri.Builder().scheme("gs").authority(this.zznns).path("/").build();
        return this.zzt(uri);
    }

    @NonNull
    public StorageReference getReferenceFromUrl(@NonNull String string) {
        zzbp.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String string2 = string.toLowerCase();
        if (string2.startsWith("gs://") || string2.startsWith("https://") || string2.startsWith("http://")) {
            try {
                Uri uri = zzemv.zzf(this.zznfk, string);
                if (uri == null) {
                    throw new IllegalArgumentException("The storage Uri could not be parsed.");
                }
                return this.zzt(uri);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string3 = String.valueOf(string);
                Log.e((String)"FirebaseStorage", (String)(string3.length() != 0 ? "Unable to parse location:".concat(string3) : new String("Unable to parse location:")), (Throwable)unsupportedEncodingException);
                throw new IllegalArgumentException("The storage Uri could not be parsed.");
            }
        }
        throw new IllegalArgumentException("The storage Uri could not be parsed.");
    }

    @NonNull
    public StorageReference getReference(@NonNull String string) {
        zzbp.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String string2 = string.toLowerCase();
        if (string2.startsWith("gs://") || string2.startsWith("https://") || string2.startsWith("http://")) {
            throw new IllegalArgumentException("location should not be a full URL.");
        }
        return this.getReference().child(string);
    }

    @NonNull
    private final StorageReference zzt(@NonNull Uri uri) {
        zzbp.zzb((Object)uri, (Object)"uri must not be null");
        String string = this.zznns;
        zzbp.zzb((TextUtils.isEmpty((CharSequence)string) || uri.getAuthority().equalsIgnoreCase(string) ? 1 : 0) != 0, (Object)"The supplied bucketname does not match the storage bucket of the current instance.");
        return new StorageReference(uri, this);
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zznfk;
    }
}

