/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzemp;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzemv;
import com.google.android.gms.internal.zzenb;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzad;
import com.google.firebase.storage.zzu;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zznnj;
    private final Uri mUri;
    private final long zznqr;
    private final zzemp zznqs;
    private final AtomicLong zznqt;
    private int zznqu;
    private zzemq zznnl;
    private boolean zznqv;
    private volatile StorageMetadata zznoq;
    private volatile Uri zznqw;
    private volatile Exception zzkgm;
    private volatile Exception zznqx;
    private volatile int mResultCode;
    private volatile String zznqy;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zznqt = new AtomicLong(0L);
        this.zznqu = 262144;
        this.zznqw = null;
        this.zzkgm = null;
        this.zznqx = null;
        this.mResultCode = 0;
        zzbp.zzu((Object)storageReference);
        zzbp.zzu((Object)byArray);
        this.zznqr = byArray.length;
        this.zznnj = storageReference;
        this.zznoq = storageMetadata;
        this.mUri = null;
        this.zznqs = new zzemp(new ByteArrayInputStream(byArray), 262144);
        this.zznqv = true;
        this.zznnl = new zzemq(this.zznnj.getStorage().getApp(), this.zznnj.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zznqt = new AtomicLong(0L);
            this.zznqu = 262144;
            this.zznqw = null;
            this.zzkgm = null;
            this.zznqx = null;
            this.mResultCode = 0;
            zzbp.zzu((Object)storageReference);
            zzbp.zzu((Object)uri);
            this.zznnj = storageReference;
            this.zznoq = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zznnl = new zzemq(this.zznnj.getStorage().getApp(), this.zznnj.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zznnj.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzkgm = fileNotFoundException;
            }
        }
        this.zznqr = l;
        this.zznqs = new zzemp(inputStream, 262144);
        this.zznqv = true;
        this.zznqw = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zznqt = new AtomicLong(0L);
        this.zznqu = 262144;
        this.zznqw = null;
        this.zzkgm = null;
        this.zznqx = null;
        this.mResultCode = 0;
        zzbp.zzu((Object)storageReference);
        zzbp.zzu((Object)inputStream);
        this.zznqr = -1L;
        this.zznnj = storageReference;
        this.zznoq = storageMetadata;
        this.zznqs = new zzemp(inputStream, 262144);
        this.zznqv = false;
        this.mUri = null;
        this.zznnl = new zzemq(this.zznnj.getStorage().getApp(), this.zznnj.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zznnj;
    }

    final long getTotalByteCount() {
        return this.zznqr;
    }

    @Override
    protected void schedule() {
        zzu.zzr(this.zzbje());
    }

    @Override
    final void run() {
        zzenb zzenb2;
        UploadTask uploadTask;
        block24: {
            this.zznnl.reset();
            if (!this.zzk(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zznnj.getParent() == null) {
                this.zzkgm = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzkgm != null) {
                return;
            }
            if (this.zznqw == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zznoq != null) {
                    string2 = uploadTask.zznoq.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zznnj.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    zzenb2 = uploadTask.zznnj.zzchz().zza(uploadTask.zznnj.zzcia(), uploadTask.zznoq != null ? uploadTask.zznoq.zzchx() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzkgm = throwable;
                    break block24;
                }
                if (uploadTask.zzc(zzenb2) && !TextUtils.isEmpty((CharSequence)(string = zzenb2.zzsd("X-Goog-Upload-URL")))) {
                    uploadTask.zznqw = Uri.parse((String)string);
                }
            } else {
                this.zzcq(false);
            }
        }
        boolean bl = this.zzcil();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zznqs.zzhs(uploadTask.zznqu);
                    int n = Math.min(uploadTask.zznqu, uploadTask.zznqs.available());
                    try {
                        zzenb2 = uploadTask.zznnj.zzchz().zza(uploadTask.zznnj.zzcia(), uploadTask.zznqw.toString(), uploadTask.zznqs.zzcip(), uploadTask.zznqt.get(), n, uploadTask.zznqs.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzkgm = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(zzenb2)) {
                        int n2 = uploadTask.zznqu = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zznqt.getAndAdd(n);
                    if (!uploadTask.zznqs.isFinished()) {
                        uploadTask.zznqs.zzhr(n);
                        if (uploadTask.zznqu < 0x2000000) {
                            uploadTask.zznqu <<= 1;
                            int n3 = uploadTask.zznqu;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zznoq = new StorageMetadata.Builder(zzenb2.zzciy(), uploadTask.zznnj).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(zzenb2.zzcit());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzkgm = throwable;
                        break block25;
                    }
                    uploadTask.zzk(4, false);
                    uploadTask.zzk(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzkgm = iOException;
                }
            }
            if (!(bl = this.zzcil())) continue;
            this.zzk(4, false);
        }
        if (this.zznqv && this.zzcic() != 16) {
            try {
                this.zznqs.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzkgm = null;
        this.zznqx = null;
        this.mResultCode = 0;
        this.zznqy = null;
    }

    private final boolean zzcil() {
        if (this.zzcic() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzkgm = new InterruptedException();
            this.zzk(64, false);
            return false;
        }
        if (this.zzcic() == 32) {
            this.zzk(256, false);
            return false;
        }
        if (this.zzcic() == 8) {
            this.zzk(16, false);
            return false;
        }
        if (!this.zzcim()) {
            return false;
        }
        if (this.zznqw == null) {
            if (this.zzkgm == null) {
                this.zzkgm = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzk(64, false);
            return false;
        }
        if (this.zzkgm != null) {
            this.zzk(64, false);
            return false;
        }
        if ((this.zznqx != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzcq(true)) {
            if (this.zzcim()) {
                this.zzk(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzcim() {
        if ("final".equals(this.zznqy)) {
            if (this.zzkgm == null) {
                this.zzkgm = new IOException("The server has terminated the upload session");
            }
            this.zzk(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzcq(boolean bl) {
        zzenb zzenb2;
        try {
            zzenb2 = this.zznnj.zzchz().zzb(this.zznnj.zzcia(), this.zznqw.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzkgm = remoteException;
            return false;
        }
        if ("final".equals(this.zznqy)) {
            return false;
        }
        if (bl ? !this.zzc(zzenb2) : !this.zzb(zzenb2)) {
            return false;
        }
        if ("final".equals(zzenb2.zzsd("X-Goog-Upload-Status"))) {
            this.zzkgm = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzenb2.zzsd("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zznqt.get();
        if (l2 > l) {
            this.zzkgm = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zznqs.zzhr((int)(l - l2)) != l - l2) {
                    this.zzkgm = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zznqt.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzkgm = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzkgm = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(zzenb zzenb2) {
        zzenb2.zze(zzemv.zzg(this.zznnj.getStorage().getApp()), this.zznnj.getStorage().getApp().getApplicationContext());
        return this.zzd(zzenb2);
    }

    private final boolean zzc(zzenb zzenb2) {
        zzenb zzenb3 = zzenb2;
        this.zznnl.zza(zzenb3, true);
        return this.zzd(zzenb2);
    }

    private final boolean zzd(zzenb zzenb2) {
        int n = zzenb2.getResultCode();
        this.mResultCode = zzemq.zzhu(n) ? -2 : n;
        this.zznqx = zzenb2.getException();
        this.zznqy = zzenb2.zzsd("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zznqx == null;
    }

    @Override
    protected void onCanceled() {
        this.zznnl.cancel();
        zzenb zzenb2 = null;
        if (this.zznqw != null) {
            try {
                zzenb2 = this.zznnj.zzchz().zza(this.zznnj.zzcia(), this.zznqw.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzenb2 != null) {
            zzenb zzenb3 = zzenb2;
            zzu.zzq(new zzad(this, zzenb3));
        }
        this.zzkgm = StorageException.fromErrorStatus(Status.zzfhz);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzchw() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzkgm != null ? uploadTask.zzkgm : uploadTask.zznqx;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zznqt.get(), uploadTask.zznqw, uploadTask.zznoq);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zznnj;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zznrb;
        private final Uri zznqw;
        private final StorageMetadata zznoq;
        private /* synthetic */ UploadTask zznra;

        TaskSnapshot(@Nullable UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zznra = uploadTask;
            super(uploadTask, exception);
            this.zznrb = l;
            this.zznqw = uri;
            this.zznoq = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zznrb;
        }

        public long getTotalByteCount() {
            return this.zznra.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zznqw;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zznoq;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

