/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzeww;
import com.google.android.gms.internal.zzewx;
import com.google.android.gms.internal.zzewz;
import com.google.firebase.FirebaseApp;
import org.json.JSONObject;

public final class zzewy {
    private static final Object zzohs = new Object();
    private static volatile zzewy zzoht;
    private zzeww zzohu;
    private Context mContext;
    private FirebaseApp zzody;

    private zzewy(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        this.mContext = firebaseApp.getApplicationContext();
        this.zzody = firebaseApp;
        try {
            IInterface iInterface;
            DynamiteModule dynamiteModule = DynamiteModule.zza((Context)this.mContext, (DynamiteModule.zzd)DynamiteModule.zzgum, (String)"com.google.android.gms.firebasestorage");
            IBinder iBinder = dynamiteModule.zzgx("com.google.firebase.storage.network.NetworkRequestFactoryImpl");
            this.zzohu = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.firebase.storage.network.INetworkRequestFactory")) instanceof zzeww ? (zzeww)iInterface : new zzewx(iBinder));
        }
        catch (DynamiteModule.zzc zzc2) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"NetworkRequestFactoryProxy failed with a RemoteException:", (Throwable)zzc2);
            throw new RemoteException();
        }
        if (this.zzohu == null) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"Unable to load Firebase Storage Network layer.");
            throw new RemoteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzewy zzh(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        if (zzoht == null) {
            Object object = zzohs;
            synchronized (object) {
                if (zzoht == null) {
                    zzoht = new zzewy(firebaseApp);
                }
            }
        }
        return zzoht;
    }

    private final zzewz zze(zzewz zzewz2) {
        zzewz2.zzbq("x-firebase-gmpid", this.zzody.getOptions().getApplicationId());
        return zzewz2;
    }

    @NonNull
    public final zzewz zzv(Uri uri) throws RemoteException {
        return this.zze(new zzewz(this.zzohu.zza(uri, zzn.zzy((Object)this.mContext))));
    }

    @NonNull
    public final zzewz zzw(Uri uri) throws RemoteException {
        return this.zze(new zzewz(this.zzohu.zzb(uri, zzn.zzy((Object)this.mContext))));
    }

    @NonNull
    public final zzewz zza(Uri uri, long l) throws RemoteException {
        return this.zze(new zzewz(this.zzohu.zza(uri, zzn.zzy((Object)this.mContext), l)));
    }

    @NonNull
    public final zzewz zza(Uri uri, String string, byte[] byArray, long l, int n, boolean bl) throws RemoteException {
        return this.zze(new zzewz(this.zzohu.zza(uri, zzn.zzy((Object)this.mContext), string, zzn.zzy((Object)byArray), l, n, bl)));
    }

    @Nullable
    public final zzewz zza(Uri uri, String string) throws RemoteException {
        return this.zze(new zzewz(this.zzohu.zza(uri, zzn.zzy((Object)this.mContext), string)));
    }

    @NonNull
    public final zzewz zzb(Uri uri, String string) throws RemoteException {
        return this.zze(new zzewz(this.zzohu.zzb(uri, zzn.zzy((Object)this.mContext), string)));
    }

    @NonNull
    public final zzewz zza(Uri uri, JSONObject jSONObject, String string) throws RemoteException {
        return this.zze(new zzewz(this.zzohu.zza(uri, zzn.zzy((Object)this.mContext), zzn.zzy((Object)jSONObject), string)));
    }

    @NonNull
    public final zzewz zza(Uri uri, JSONObject jSONObject) throws RemoteException {
        return this.zze(new zzewz(this.zzohu.zza(uri, zzn.zzy((Object)this.mContext), zzn.zzy((Object)jSONObject))));
    }

    @Nullable
    public final String zzcko() {
        try {
            return this.zzohu.zzcko();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getBackendAuthority failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @Nullable
    public final String zzu(Uri uri) {
        try {
            return this.zzohu.zzu(uri);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getDefaultURL failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }
}

