/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzewo;
import com.google.android.gms.internal.zzewy;
import com.google.android.gms.internal.zzewz;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzods;
    private long zzodt;
    private StorageReference zzodp;
    private zzewo zzodr;
    private long zzgjr = -1L;
    private String zzodu = null;
    private volatile Exception zzksh = null;
    private long zzodv = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzodp = storageReference;
        this.zzods = uri;
        this.zzodr = new zzewo(this.zzodp.getStorage().getApp(), this.zzodp.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzgjr;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzodp;
    }

    @Override
    protected void schedule() {
        zzt.zzu(this.zzbkc());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzksh = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzewz zzewz2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzewz2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzods.getPath());
            if (!file.exists()) {
                if (this.zzodv > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzodv > 0L) {
                object = file.getAbsolutePath();
                long l = this.zzodv;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzodt += (long)n;
                    if (this.zzksh != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzksh);
                        this.zzksh = null;
                        bl = false;
                    }
                    if (this.zzk(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzksh = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzksh != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        do {
            Object object;
            zzewz zzewz2;
            this.zzodt = 0L;
            this.zzksh = null;
            this.zzodr.reset();
            try {
                zzewz2 = zzewy.zzh(this.zzodp.getStorage().getApp()).zza(this.zzodp.zzcjr(), this.zzodv);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzksh = remoteException;
                this.zzk(64, false);
                return;
            }
            this.zzodr.zza(zzewz2, false);
            this.mResultCode = zzewz2.getResultCode();
            this.zzksh = zzewz2.getException() != null ? zzewz2.getException() : this.zzksh;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzksh == null && this.zzcjt() == 4;
            if (bl) {
                this.zzgjr = zzewz2.zzckn();
                object = zzewz2.zzry("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzodu != null && !this.zzodu.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzodv = 0L;
                    this.zzodu = null;
                    zzewz2.zzckh();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zzodu = object;
                try {
                    bl = this.zza(zzewz2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzksh = iOException;
                }
            }
            zzewz2.zzckh();
            if (bl && this.zzksh == null && this.zzcjt() == 4) {
                this.zzk(128, false);
                return;
            }
            object = new File(this.zzods.getPath());
            this.zzodv = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcjt() == 8) {
                this.zzk(16, false);
                return;
            }
            if (this.zzcjt() != 32) continue;
            if (!this.zzk(256, false)) {
                int n2 = this.zzcjt();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzodt > 0L);
        this.zzk(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzodr.cancel();
        this.zzksh = StorageException.fromErrorStatus(Status.zzflc);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcjo() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzksh, fileDownloadTask.mResultCode)), fileDownloadTask.zzodt + fileDownloadTask.zzodv);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzodt;
        private /* synthetic */ FileDownloadTask zzodw;

        TaskSnapshot(FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzodw = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzodt = l;
        }

        public long getBytesTransferred() {
            return this.zzodt;
        }

        public long getTotalByteCount() {
            return this.zzodw.getTotalBytes();
        }
    }
}

