/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzewp;
import com.google.android.gms.internal.zzewt;
import com.google.android.gms.internal.zzewy;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzc;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzoei = null;
    private StorageReference zzodp = null;
    private String zzoej = null;
    private String zzoek = null;
    private String zzeno = null;
    private String zzoel = null;
    private String zzoem = null;
    private String zzoen = null;
    private long zzoeo;
    private String zzoep = null;
    private String zzoeq = null;
    private String zzoer = null;
    private String zzoes = null;
    private String zzoet = null;
    private Map<String, String> zzoeu = null;
    private String[] zzoev = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbq.checkNotNull((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzoei = storageMetadata.zzoei;
        this.zzodp = storageMetadata.zzodp;
        this.zzoej = storageMetadata.zzoej;
        this.zzeno = storageMetadata.zzeno;
        this.zzoeq = storageMetadata.zzoeq;
        this.zzoer = storageMetadata.zzoer;
        this.zzoes = storageMetadata.zzoes;
        this.zzoet = storageMetadata.zzoet;
        if (storageMetadata.zzoeu != null) {
            this.zzoeu = new HashMap<String, String>(storageMetadata.zzoeu);
        }
        this.zzoev = storageMetadata.zzoev;
        if (bl) {
            this.zzoep = storageMetadata.zzoep;
            this.zzoeo = storageMetadata.zzoeo;
            this.zzoen = storageMetadata.zzoen;
            this.zzoem = storageMetadata.zzoem;
            this.zzoel = storageMetadata.zzoel;
            this.zzoek = storageMetadata.zzoek;
        }
    }

    public String getContentType() {
        return this.zzeno;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzoeu == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzoeu.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzoeu == null) {
            return Collections.emptySet();
        }
        return this.zzoeu.keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzoej;
    }

    @Nullable
    public String getGeneration() {
        return this.zzoek;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzoel;
    }

    public long getCreationTimeMillis() {
        return zzewt.zzrv(this.zzoem);
    }

    public long getUpdatedTimeMillis() {
        return zzewt.zzrv(this.zzoen);
    }

    public long getSizeBytes() {
        return this.zzoeo;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzoep;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzoev != null && this.zzodp != null) {
            try {
                String string = zzewy.zzh(this.zzodp.getStorage().getApp()).zzu(this.zzodp.zzcjr());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzoev;
                    int n = this.zzoev.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzoeq;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzoer;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzoes;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzoet;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzodp == null && this.zzoei != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzewp.zzrs((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzoei);
        }
        return this.zzodp;
    }

    @NonNull
    final JSONObject zzcjp() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzoeu != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzoeu));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private final void zzrr(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzoev = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzc zzc2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzoew;
        private boolean zzoex;

        public Builder() {
            this.zzoew = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzoew = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzoew.zzodp = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzoew = new StorageMetadata();
            if (jSONObject != null) {
                this.zzac(jSONObject);
                this.zzoex = true;
            }
        }

        private final void zzac(JSONObject jSONObject) throws JSONException {
            this.zzoew.zzoek = jSONObject.optString("generation");
            this.zzoew.mPath = jSONObject.optString("name");
            this.zzoew.zzoej = jSONObject.optString("bucket");
            this.zzoew.zzoel = jSONObject.optString("metageneration");
            this.zzoew.zzoem = jSONObject.optString("timeCreated");
            this.zzoew.zzoen = jSONObject.optString("updated");
            this.zzoew.zzoeo = jSONObject.optLong("size");
            this.zzoew.zzoep = jSONObject.optString("md5Hash");
            this.zzoew.zzrr(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzoew, this.zzoex, null);
        }

        public Builder setContentLanguage(String string) {
            this.zzoew.zzoet = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzoew.zzoes = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzoew.zzoer = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzoew.zzoeq = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzoew.zzoeu == null) {
                this.zzoew.zzoeu = new HashMap();
            }
            this.zzoew.zzoeu.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzoew.zzeno = string;
            return this;
        }
    }
}

