/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzewo;
import com.google.android.gms.internal.zzewz;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzv;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzodp;
    private zzewo zzodr;
    private volatile Exception zzksh = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzogb;
    private long zzgjr = -1L;
    private long zzodt;
    private long zzogc;
    private InputStream zzlgp;
    private zzewz zzogd;
    private String zzodu;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzodp = storageReference;
        this.zzodr = new zzewo(this.zzodp.getStorage().getApp(), this.zzodp.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbq.checkNotNull((Object)streamProcessor);
        zzbq.checkState((this.zzogb == null ? 1 : 0) != 0);
        this.zzogb = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzodp;
    }

    final long getTotalBytes() {
        return this.zzgjr;
    }

    final void zzco(long l) {
        this.zzodt += l;
        if (this.zzogc + 262144L <= this.zzodt) {
            if (this.zzcjt() == 4) {
                this.zzk(4, false);
                return;
            }
            this.zzogc = this.zzodt;
        }
    }

    @Override
    protected void schedule() {
        zzt.zzu(this.zzbkc());
    }

    private final InputStream zzcjy() throws Exception {
        this.zzodr.reset();
        if (this.zzogd != null) {
            this.zzogd.zzckh();
        }
        try {
            this.zzogd = this.zzodp.zzcjq().zza(this.zzodp.zzcjr(), this.zzodt);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzodr.zza(this.zzogd, false);
        this.mResultCode = this.zzogd.getResultCode();
        this.zzksh = this.zzogd.getException() != null ? this.zzogd.getException() : this.zzksh;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzksh == null && this.zzcjt() == 4) {
            String string = this.zzogd.zzry("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzodu != null && !this.zzodu.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzodu = string;
            if (this.zzgjr == -1L) {
                this.zzgjr = this.zzogd.zzckn();
            }
            return this.zzogd.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzksh != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzv(this), this);
        this.zzlgp = new BufferedInputStream(zza2);
        try {
            zza2.zzcka();
            if (this.zzogb != null) {
                try {
                    this.zzogb.doInBackground((TaskSnapshot)this.zzcju(), this.zzlgp);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzksh = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzksh = iOException;
        }
        if (this.zzlgp == null) {
            this.zzogd.zzckh();
            this.zzogd = null;
        }
        if (this.zzksh == null && this.zzcjt() == 4) {
            this.zzk(4, false);
            this.zzk(128, false);
            return;
        }
        if (!this.zzk(this.zzcjt() == 32 ? 256 : 64, false)) {
            int n = this.zzcjt();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzodr.cancel();
        this.zzksh = StorageException.fromErrorStatus(Status.zzflc);
    }

    @Override
    protected void onProgress() {
        this.zzogc = this.zzodt;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcjo() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzksh, streamDownloadTask.mResultCode)), streamDownloadTask.zzogc);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzcjy();
    }

    static /* synthetic */ zzewz zza(StreamDownloadTask streamDownloadTask, zzewz zzewz2) {
        streamDownloadTask.zzogd = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzodt;
        private /* synthetic */ StreamDownloadTask zzoge;

        TaskSnapshot(StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzoge = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzodt = l;
        }

        public long getBytesTransferred() {
            return this.zzodt;
        }

        public long getTotalByteCount() {
            return this.zzoge.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzoge.zzlgp;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzogf;
        @Nullable
        private InputStream zzogg;
        private Callable<InputStream> zzogh;
        private IOException zzogi;
        private int zzogj;
        private int zzogk;
        private boolean zzogl;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzogf = streamDownloadTask;
            this.zzogh = callable;
        }

        private final void zzcjz() throws IOException {
            if (this.zzogf != null && this.zzogf.zzcjt() == 32) {
                throw StorageException.zzoee;
            }
        }

        private final void zzco(long l) {
            if (this.zzogf != null) {
                this.zzogf.zzco(l);
            }
            this.zzogj = (int)((long)this.zzogj + l);
        }

        private final boolean zzcka() throws IOException {
            this.zzcjz();
            if (this.zzogi != null) {
                try {
                    if (this.zzogg != null) {
                        this.zzogg.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzogg = null;
                if (this.zzogk == this.zzogj) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzogi);
                    return false;
                }
                int n = this.zzogj;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzogi);
                this.zzogk = this.zzogj;
                this.zzogi = null;
            }
            if (this.zzogl) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzogg == null) {
                try {
                    this.zzogg = this.zzogh.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzcka()) {
                try {
                    int n = this.zzogg.read();
                    if (n != -1) {
                        this.zzco(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzogi = iOException;
                }
            }
            throw this.zzogi;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzcka()) {
                try {
                    return this.zzogg.available();
                }
                catch (IOException iOException) {
                    this.zzogi = iOException;
                }
            }
            throw this.zzogi;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzogg != null) {
                this.zzogg.close();
            }
            this.zzogl = true;
            if (this.zzogf != null && this.zzogf.zzogd != null) {
                this.zzogf.zzogd.zzckh();
                StreamDownloadTask.zza(this.zzogf, null);
            }
            this.zzcjz();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzcka()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzogg.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzco(n4);
                        this.zzcjz();
                    }
                    if (n2 > 0) {
                        n4 = this.zzogg.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzco(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzogi = iOException;
                }
            }
            throw this.zzogi;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzcka()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzogg.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzco(l2);
                        this.zzcjz();
                    }
                    if (l > 0L) {
                        l2 = this.zzogg.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzco(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzogi = iOException;
                }
            }
            throw this.zzogi;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

