/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzewn;
import com.google.android.gms.internal.zzewo;
import com.google.android.gms.internal.zzewt;
import com.google.android.gms.internal.zzewz;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzac;
import com.google.firebase.storage.zzt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzodp;
    private final Uri mUri;
    private final long zzogw;
    private final zzewn zzogx;
    private final AtomicLong zzogy;
    private int zzogz;
    private zzewo zzodr;
    private boolean zzoha;
    private volatile StorageMetadata zzoew;
    private volatile Uri zzohb;
    private volatile Exception zzksh;
    private volatile Exception zzohc;
    private volatile int mResultCode;
    private volatile String zzohd;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzogy = new AtomicLong(0L);
        this.zzogz = 262144;
        this.zzohb = null;
        this.zzksh = null;
        this.zzohc = null;
        this.mResultCode = 0;
        zzbq.checkNotNull((Object)storageReference);
        zzbq.checkNotNull((Object)byArray);
        this.zzogw = byArray.length;
        this.zzodp = storageReference;
        this.zzoew = storageMetadata;
        this.mUri = null;
        this.zzogx = new zzewn(new ByteArrayInputStream(byArray), 262144);
        this.zzoha = true;
        this.zzodr = new zzewo(this.zzodp.getStorage().getApp(), this.zzodp.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzogy = new AtomicLong(0L);
            this.zzogz = 262144;
            this.zzohb = null;
            this.zzksh = null;
            this.zzohc = null;
            this.mResultCode = 0;
            zzbq.checkNotNull((Object)storageReference);
            zzbq.checkNotNull((Object)uri);
            this.zzodp = storageReference;
            this.zzoew = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzodr = new zzewo(this.zzodp.getStorage().getApp(), this.zzodp.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzodp.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzksh = fileNotFoundException;
            }
        }
        this.zzogw = l;
        this.zzogx = new zzewn(inputStream, 262144);
        this.zzoha = true;
        this.zzohb = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzogy = new AtomicLong(0L);
        this.zzogz = 262144;
        this.zzohb = null;
        this.zzksh = null;
        this.zzohc = null;
        this.mResultCode = 0;
        zzbq.checkNotNull((Object)storageReference);
        zzbq.checkNotNull((Object)inputStream);
        this.zzogw = -1L;
        this.zzodp = storageReference;
        this.zzoew = storageMetadata;
        this.zzogx = new zzewn(inputStream, 262144);
        this.zzoha = false;
        this.mUri = null;
        this.zzodr = new zzewo(this.zzodp.getStorage().getApp(), this.zzodp.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzodp;
    }

    final long getTotalByteCount() {
        return this.zzogw;
    }

    @Override
    protected void schedule() {
        zzt.zzt(this.zzbkc());
    }

    @Override
    final void run() {
        zzewz zzewz2;
        UploadTask uploadTask;
        block24: {
            this.zzodr.reset();
            if (!this.zzk(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzodp.getParent() == null) {
                this.zzksh = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzksh != null) {
                return;
            }
            if (this.zzohb == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzoew != null) {
                    string2 = uploadTask.zzoew.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzodp.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    zzewz2 = uploadTask.zzodp.zzcjq().zza(uploadTask.zzodp.zzcjr(), uploadTask.zzoew != null ? uploadTask.zzoew.zzcjp() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzksh = throwable;
                    break block24;
                }
                if (uploadTask.zzc(zzewz2) && !TextUtils.isEmpty((CharSequence)(string = zzewz2.zzry("X-Goog-Upload-URL")))) {
                    uploadTask.zzohb = Uri.parse((String)string);
                }
            } else {
                this.zzct(false);
            }
        }
        boolean bl = this.zzckc();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzogx.zzic(uploadTask.zzogz);
                    int n = Math.min(uploadTask.zzogz, uploadTask.zzogx.available());
                    try {
                        zzewz2 = uploadTask.zzodp.zzcjq().zza(uploadTask.zzodp.zzcjr(), uploadTask.zzohb.toString(), uploadTask.zzogx.zzckg(), uploadTask.zzogy.get(), n, uploadTask.zzogx.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzksh = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(zzewz2)) {
                        int n2 = uploadTask.zzogz = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzogy.getAndAdd(n);
                    if (!uploadTask.zzogx.isFinished()) {
                        uploadTask.zzogx.zzib(n);
                        if (uploadTask.zzogz < 0x2000000) {
                            uploadTask.zzogz <<= 1;
                            int n3 = uploadTask.zzogz;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzoew = new StorageMetadata.Builder(zzewz2.zzckp(), uploadTask.zzodp).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(zzewz2.zzckk());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzksh = throwable;
                        break block25;
                    }
                    uploadTask.zzk(4, false);
                    uploadTask.zzk(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzksh = iOException;
                }
            }
            if (!(bl = this.zzckc())) continue;
            this.zzk(4, false);
        }
        if (this.zzoha && this.zzcjt() != 16) {
            try {
                this.zzogx.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzksh = null;
        this.zzohc = null;
        this.mResultCode = 0;
        this.zzohd = null;
    }

    private final boolean zzckc() {
        if (this.zzcjt() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzksh = new InterruptedException();
            this.zzk(64, false);
            return false;
        }
        if (this.zzcjt() == 32) {
            this.zzk(256, false);
            return false;
        }
        if (this.zzcjt() == 8) {
            this.zzk(16, false);
            return false;
        }
        if (!this.zzckd()) {
            return false;
        }
        if (this.zzohb == null) {
            if (this.zzksh == null) {
                this.zzksh = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzk(64, false);
            return false;
        }
        if (this.zzksh != null) {
            this.zzk(64, false);
            return false;
        }
        if ((this.zzohc != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzct(true)) {
            if (this.zzckd()) {
                this.zzk(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzckd() {
        if ("final".equals(this.zzohd)) {
            if (this.zzksh == null) {
                this.zzksh = new IOException("The server has terminated the upload session");
            }
            this.zzk(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzct(boolean bl) {
        zzewz zzewz2;
        try {
            zzewz2 = this.zzodp.zzcjq().zzb(this.zzodp.zzcjr(), this.zzohb.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzksh = remoteException;
            return false;
        }
        if ("final".equals(this.zzohd)) {
            return false;
        }
        if (bl ? !this.zzc(zzewz2) : !this.zzb(zzewz2)) {
            return false;
        }
        if ("final".equals(zzewz2.zzry("X-Goog-Upload-Status"))) {
            this.zzksh = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzewz2.zzry("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzogy.get();
        if (l2 > l) {
            this.zzksh = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzogx.zzib((int)(l - l2)) != l - l2) {
                    this.zzksh = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzogy.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzksh = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzksh = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(zzewz zzewz2) {
        zzewz2.zze(zzewt.zzg(this.zzodp.getStorage().getApp()), this.zzodp.getStorage().getApp().getApplicationContext());
        return this.zzd(zzewz2);
    }

    private final boolean zzc(zzewz zzewz2) {
        zzewz zzewz3 = zzewz2;
        this.zzodr.zza(zzewz3, true);
        return this.zzd(zzewz2);
    }

    private final boolean zzd(zzewz zzewz2) {
        int n = zzewz2.getResultCode();
        this.mResultCode = zzewo.zzie(n) ? -2 : n;
        this.zzohc = zzewz2.getException();
        this.zzohd = zzewz2.zzry("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzohc == null;
    }

    @Override
    protected void onCanceled() {
        this.zzodr.cancel();
        zzewz zzewz2 = null;
        if (this.zzohb != null) {
            try {
                zzewz2 = this.zzodp.zzcjq().zza(this.zzodp.zzcjr(), this.zzohb.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzewz2 != null) {
            zzewz zzewz3 = zzewz2;
            zzt.zzs(new zzac(this, zzewz3));
        }
        this.zzksh = StorageException.fromErrorStatus(Status.zzflc);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcjo() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzksh != null ? uploadTask.zzksh : uploadTask.zzohc;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzogy.get(), uploadTask.zzohb, uploadTask.zzoew);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzodp;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzohg;
        private final Uri zzohb;
        private final StorageMetadata zzoew;
        private /* synthetic */ UploadTask zzohf;

        TaskSnapshot(UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzohf = uploadTask;
            super(uploadTask, exception);
            this.zzohg = l;
            this.zzohb = uri;
            this.zzoew = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzohg;
        }

        public long getTotalByteCount() {
            return this.zzohf.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzohb;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzoew;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

