/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzewm;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class zzewr {
    private zzewm zzohh;
    private Exception zzkrx;
    private int zzohi;
    private Exception zzohj;

    public zzewr(@NonNull zzewm zzewm2) {
        this.zzohh = zzewm2;
    }

    public final void zzbq(String string, String string2) {
        try {
            this.zzohh.zzbq(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzrx(String string) {
        try {
            return this.zzohh.zzrx(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzewr zzewr2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzewr2.zzohi = -2;
                zzewr2.zzohj = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzohh.zzrv(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzohi = 0;
            this.zzohj = null;
            this.zzohh.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzrw(@Nullable String string) {
        try {
            this.zzohh.zzrw(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzckg() {
        try {
            if (this.zzohh != null) {
                this.zzohh.zzckg();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzx((IObjectWrapper)this.zzohh.zzckh());
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzcko() throws RemoteException {
        return (JSONObject)zzn.zzx((IObjectWrapper)this.zzohh.zzcki());
    }

    @Nullable
    public final String zzckj() {
        try {
            this.zzohh.zzckj();
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzohj != null) {
                return this.zzohj;
            }
            if (this.zzkrx != null) {
                return this.zzkrx;
            }
            return (Exception)zzn.zzx((IObjectWrapper)this.zzohh.zzckk());
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzohi != 0) {
                return this.zzohi;
            }
            return this.zzohh.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzckl() {
        try {
            if (this.zzohi == -2 || this.zzohj != null) {
                return false;
            }
            return this.zzohh.zzckl();
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzckl() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzckm() {
        try {
            return this.zzohh.zzckm();
        }
        catch (RemoteException remoteException) {
            this.zzkrx = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

