/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzewg;
import com.google.android.gms.internal.zzewq;
import com.google.android.gms.internal.zzewr;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzodb;
    private long zzodc;
    private StorageReference zzocy;
    private zzewg zzoda;
    private long zzgjh = -1L;
    private String zzodd = null;
    private volatile Exception zzkrx = null;
    private long zzode = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzocy = storageReference;
        this.zzodb = uri;
        this.zzoda = new zzewg(this.zzocy.getStorage().getApp(), this.zzocy.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzgjh;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzocy;
    }

    @Override
    protected void schedule() {
        zzu.zzu(this.zzbkb());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzkrx = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzewr zzewr2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzewr2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzodb.getPath());
            if (!file.exists()) {
                if (this.zzode > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzode > 0L) {
                object = file.getAbsolutePath();
                long l = this.zzode;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzodc += (long)n;
                    if (this.zzkrx != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzkrx);
                        this.zzkrx = null;
                        bl = false;
                    }
                    if (this.zzk(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzkrx = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzkrx != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        do {
            Object object;
            zzewr zzewr2;
            this.zzodc = 0L;
            this.zzkrx = null;
            this.zzoda.reset();
            try {
                zzewr2 = zzewq.zzh(this.zzocy.getStorage().getApp()).zza(this.zzocy.zzcjq(), this.zzode);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzkrx = remoteException;
                this.zzk(64, false);
                return;
            }
            this.zzoda.zza(zzewr2, false);
            this.mResultCode = zzewr2.getResultCode();
            this.zzkrx = zzewr2.getException() != null ? zzewr2.getException() : this.zzkrx;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzkrx == null && this.zzcjs() == 4;
            if (bl) {
                this.zzgjh = zzewr2.zzckm();
                object = zzewr2.zzrx("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzodd != null && !this.zzodd.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzode = 0L;
                    this.zzodd = null;
                    zzewr2.zzckg();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zzodd = object;
                try {
                    bl = this.zza(zzewr2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzkrx = iOException;
                }
            }
            zzewr2.zzckg();
            if (bl && this.zzkrx == null && this.zzcjs() == 4) {
                this.zzk(128, false);
                return;
            }
            object = new File(this.zzodb.getPath());
            this.zzode = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcjs() == 8) {
                this.zzk(16, false);
                return;
            }
            if (this.zzcjs() != 32) continue;
            if (!this.zzk(256, false)) {
                int n2 = this.zzcjs();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzodc > 0L);
        this.zzk(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzoda.cancel();
        this.zzkrx = StorageException.fromErrorStatus(Status.zzfks);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcjm() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzkrx, fileDownloadTask.mResultCode)), fileDownloadTask.zzodc + fileDownloadTask.zzode);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzodc;
        private /* synthetic */ FileDownloadTask zzodf;

        TaskSnapshot(@Nullable FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzodf = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzodc = l;
        }

        public long getBytesTransferred() {
            return this.zzodc;
        }

        public long getTotalByteCount() {
            return this.zzodf.getTotalBytes();
        }
    }
}

