/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzewh;
import com.google.android.gms.internal.zzewl;
import com.google.android.gms.internal.zzewq;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzd;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzodr = null;
    private StorageReference zzocy = null;
    private String zzods = null;
    private String zzodt = null;
    private zza<String> zzodu = zza.zzci("");
    private String zzodv = null;
    private String zzodw = null;
    private String zzodx = null;
    private long zzody;
    private String zzodz = null;
    private zza<String> zzoea = zza.zzci("");
    private zza<String> zzoeb = zza.zzci("");
    private zza<String> zzoec = zza.zzci("");
    private zza<String> zzoed = zza.zzci("");
    private zza<Map<String, String>> zzoee = zza.zzci(Collections.emptyMap());
    private String[] zzoef = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbq.checkNotNull((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzodr = storageMetadata.zzodr;
        this.zzocy = storageMetadata.zzocy;
        this.zzods = storageMetadata.zzods;
        this.zzodu = storageMetadata.zzodu;
        this.zzoea = storageMetadata.zzoea;
        this.zzoeb = storageMetadata.zzoeb;
        this.zzoec = storageMetadata.zzoec;
        this.zzoed = storageMetadata.zzoed;
        this.zzoee = storageMetadata.zzoee;
        this.zzoef = storageMetadata.zzoef;
        if (bl) {
            this.zzodz = storageMetadata.zzodz;
            this.zzody = storageMetadata.zzody;
            this.zzodx = storageMetadata.zzodx;
            this.zzodw = storageMetadata.zzodw;
            this.zzodv = storageMetadata.zzodv;
            this.zzodt = storageMetadata.zzodt;
        }
    }

    public String getContentType() {
        return this.zzodu.getValue();
    }

    public String getCustomMetadata(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzoee.getValue().get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        return this.zzoee.getValue().keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzods;
    }

    @Nullable
    public String getGeneration() {
        return this.zzodt;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzodv;
    }

    public long getCreationTimeMillis() {
        return zzewl.zzru(this.zzodw);
    }

    public long getUpdatedTimeMillis() {
        return zzewl.zzru(this.zzodx);
    }

    public long getSizeBytes() {
        return this.zzody;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzodz;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzoef != null && this.zzocy != null) {
            try {
                String string = zzewq.zzh(this.zzocy.getStorage().getApp()).zzu(this.zzocy.zzcjq());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzoef;
                    int n = this.zzoef.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzoea.getValue();
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzoeb.getValue();
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzoec.getValue();
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzoed.getValue();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzocy == null && this.zzodr != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzewh.zzrr((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzodr);
        }
        return this.zzocy;
    }

    @NonNull
    final JSONObject zzcjn() throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.zzodu.zzcjo()) {
            hashMap.put("contentType", this.getContentType());
        }
        if (this.zzoee.zzcjo()) {
            hashMap.put("metadata", (String)new JSONObject(this.zzoee.getValue()));
        }
        if (this.zzoea.zzcjo()) {
            hashMap.put("cacheControl", this.getCacheControl());
        }
        if (this.zzoeb.zzcjo()) {
            hashMap.put("contentDisposition", this.getContentDisposition());
        }
        if (this.zzoec.zzcjo()) {
            hashMap.put("contentEncoding", this.getContentEncoding());
        }
        if (this.zzoed.zzcjo()) {
            hashMap.put("contentLanguage", this.getContentLanguage());
        }
        return new JSONObject(hashMap);
    }

    private final void zzrq(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzoef = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzd zzd2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzoeg;
        private boolean zzoeh;

        public Builder() {
            this.zzoeg = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzoeg = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzoeg.zzocy = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzoeg = new StorageMetadata();
            if (jSONObject != null) {
                this.zzac(jSONObject);
                this.zzoeh = true;
            }
        }

        @Nullable
        private static String zze(JSONObject jSONObject, String string) throws JSONException {
            if (jSONObject.has(string) && !jSONObject.isNull(string)) {
                return jSONObject.getString(string);
            }
            return null;
        }

        private final void zzac(JSONObject jSONObject) throws JSONException {
            String string;
            this.zzoeg.zzodt = jSONObject.optString("generation");
            this.zzoeg.mPath = jSONObject.optString("name");
            this.zzoeg.zzods = jSONObject.optString("bucket");
            this.zzoeg.zzodv = jSONObject.optString("metageneration");
            this.zzoeg.zzodw = jSONObject.optString("timeCreated");
            this.zzoeg.zzodx = jSONObject.optString("updated");
            this.zzoeg.zzody = jSONObject.optLong("size");
            this.zzoeg.zzodz = jSONObject.optString("md5Hash");
            this.zzoeg.zzrq(jSONObject.optString("downloadTokens"));
            if (jSONObject.has("metadata") && !jSONObject.isNull("metadata")) {
                string = jSONObject.getJSONObject("metadata");
                Iterator iterator = string.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.setCustomMetadata(string2, string.getString(string2));
                }
            }
            if ((string = Builder.zze(jSONObject, "contentType")) != null) {
                this.setContentType(string);
            }
            if ((string = Builder.zze(jSONObject, "cacheControl")) != null) {
                this.setCacheControl(string);
            }
            if ((string = Builder.zze(jSONObject, "contentDisposition")) != null) {
                this.setContentDisposition(string);
            }
            if ((string = Builder.zze(jSONObject, "contentEncoding")) != null) {
                this.setContentEncoding(string);
            }
            if ((string = Builder.zze(jSONObject, "contentLanguage")) != null) {
                this.setContentLanguage(string);
            }
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzoeg, this.zzoeh, null);
        }

        public Builder setContentLanguage(@Nullable String string) {
            this.zzoeg.zzoed = zza.zzcj(string);
            return this;
        }

        public Builder setContentEncoding(@Nullable String string) {
            this.zzoeg.zzoec = zza.zzcj(string);
            return this;
        }

        public Builder setContentDisposition(@Nullable String string) {
            this.zzoeg.zzoeb = zza.zzcj(string);
            return this;
        }

        public Builder setCacheControl(@Nullable String string) {
            this.zzoeg.zzoea = zza.zzcj(string);
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (!this.zzoeg.zzoee.zzcjo()) {
                this.zzoeg.zzoee = zza.zzcj(new HashMap());
            }
            ((Map)this.zzoeg.zzoee.getValue()).put(string, string2);
            return this;
        }

        public Builder setContentType(@Nullable String string) {
            this.zzoeg.zzodu = zza.zzcj(string);
            return this;
        }
    }

    static final class zza<T> {
        private final boolean zzoei;
        @Nullable
        private final T value;

        private zza(@Nullable T t, boolean bl) {
            this.zzoei = bl;
            this.value = t;
        }

        static <T> zza<T> zzci(T t) {
            return new zza<T>(t, false);
        }

        static <T> zza<T> zzcj(@Nullable T t) {
            return new zza<T>(t, true);
        }

        final boolean zzcjo() {
            return this.zzoei;
        }

        @Nullable
        final T getValue() {
            return this.value;
        }
    }
}

