/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzfbi;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

@Hide
public final class zzfbn {
    private zzfbi zza;
    private Exception zzb;
    private int zzc;
    private Exception zzd;

    public zzfbn(@NonNull zzfbi zzfbi2) {
        this.zza = zzfbi2;
    }

    public final void zza(String string, String string2) {
        try {
            this.zza.zza(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zza(String string) {
        try {
            return this.zza.zzc(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zza(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzfbn zzfbn2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzfbn2.zzc = -2;
                zzfbn2.zzd = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zza.zza(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza(this.zzb, "performRequest failed with a RemoteException");
            return;
        }
    }

    public final void zza() {
        try {
            this.zzc = 0;
            this.zzd = null;
            this.zza.zza();
            return;
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "reset failed with a RemoteException");
            return;
        }
    }

    public final void zzb(@Nullable String string) {
        try {
            this.zza.zzb(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "performRequestStart failed with a RemoteException");
            return;
        }
    }

    public final void zzb() {
        try {
            if (this.zza != null) {
                this.zza.zzb();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "performRequestEnd failed with a RemoteException");
            return;
        }
    }

    @Nullable
    public final InputStream zzc() {
        try {
            return (InputStream)zzn.zza((IObjectWrapper)this.zza.zzc());
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getStream failed with a RemoteException");
            return null;
        }
    }

    @NonNull
    public final JSONObject zzd() throws RemoteException {
        return (JSONObject)zzn.zza((IObjectWrapper)this.zza.zzd());
    }

    @Nullable
    public final String zze() {
        try {
            this.zza.zze();
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getRawResult failed with a RemoteException");
        }
        return null;
    }

    @Nullable
    public final Exception zzf() {
        try {
            if (this.zzd != null) {
                return this.zzd;
            }
            if (this.zzb != null) {
                return this.zzb;
            }
            return (Exception)zzn.zza((IObjectWrapper)this.zza.zzf());
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getException failed with a RemoteException");
            return null;
        }
    }

    public final int zzg() {
        try {
            if (this.zzc != 0) {
                return this.zzc;
            }
            return this.zza.zzg();
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getResultCode failed with a RemoteException");
            return 0;
        }
    }

    public final boolean zzh() {
        try {
            if (this.zzc == -2 || this.zzd != null) {
                return false;
            }
            return this.zza.zzh();
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "isResultSuccess failed with a RemoteException");
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.zzf();
        if (this.zzh() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.zzg());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzi() {
        try {
            return this.zza.zzi();
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getResultingContentLength failed with a RemoteException");
            return 0;
        }
    }

    private final void zza(Exception exception, String string) {
        Log.e((String)"NetworkRequestProxy", (String)string, (Throwable)exception);
        this.zzb = exception;
    }
}

