/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.inject.Provider;
import com.google.firebase.storage.FirebaseStorage;
import java.util.HashMap;
import java.util.Map;

class FirebaseStorageComponent {
    private final Map<String, FirebaseStorage> instances = new HashMap<String, FirebaseStorage>();
    private final FirebaseApp app;
    @Nullable
    private final Provider<InternalAuthProvider> authProvider;

    FirebaseStorageComponent(@NonNull FirebaseApp app, @Nullable Provider<InternalAuthProvider> authProvider) {
        this.app = app;
        this.authProvider = authProvider;
    }

    @NonNull
    synchronized FirebaseStorage get(@Nullable String bucketName) {
        FirebaseStorage storage = this.instances.get(bucketName);
        if (storage == null) {
            storage = new FirebaseStorage(bucketName, this.app, this.authProvider);
            this.instances.put(bucketName, storage);
        }
        return storage;
    }

    @VisibleForTesting
    synchronized void clearInstancesForTesting() {
        this.instances.clear();
    }
}

