/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.TaskListenerImpl$$Lambda$1;
import com.google.firebase.storage.TaskListenerImpl$$Lambda$2;
import com.google.firebase.storage.TaskListenerImpl$$Lambda$3;
import com.google.firebase.storage.internal.ActivityLifecycleListener;
import com.google.firebase.storage.internal.SmartHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

class TaskListenerImpl<ListenerTypeT, ResultT extends StorageTask.ProvideError> {
    private final Queue<ListenerTypeT> listenerQueue = new ConcurrentLinkedQueue<ListenerTypeT>();
    private final HashMap<ListenerTypeT, SmartHandler> handlerMap = new HashMap();
    private StorageTask<ResultT> task;
    private int targetStates;
    private OnRaise<ListenerTypeT, ResultT> onRaise;

    public TaskListenerImpl(@NonNull StorageTask<ResultT> task, int targetInternalStates, @NonNull OnRaise<ListenerTypeT, ResultT> onRaise) {
        this.task = task;
        this.targetStates = targetInternalStates;
        this.onRaise = onRaise;
    }

    public int getListenerCount() {
        return Math.max(this.listenerQueue.size(), this.handlerMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@Nullable Activity activity, @Nullable Executor executor, @NonNull ListenerTypeT listener) {
        SmartHandler handler;
        Preconditions.checkNotNull(listener);
        boolean shouldFire = false;
        Object object = this.task.getSyncObject();
        synchronized (object) {
            if ((this.task.getInternalState() & this.targetStates) != 0) {
                shouldFire = true;
            }
            this.listenerQueue.add(listener);
            handler = new SmartHandler(executor);
            this.handlerMap.put(listener, handler);
            if (activity != null) {
                if (Build.VERSION.SDK_INT >= 17) {
                    Preconditions.checkArgument((!activity.isDestroyed() ? 1 : 0) != 0, (Object)"Activity is already destroyed!");
                }
                ActivityLifecycleListener.getInstance().runOnActivityStopped(activity, listener, TaskListenerImpl$$Lambda$1.lambdaFactory$(this, listener));
            }
        }
        if (shouldFire) {
            ResultT snappedState = this.task.snapState();
            handler.callBack(TaskListenerImpl$$Lambda$2.lambdaFactory$(this, listener, snappedState));
        }
    }

    public void onInternalStateChanged() {
        if ((this.task.getInternalState() & this.targetStates) != 0) {
            ResultT snappedState = this.task.snapState();
            Iterator iterator = this.listenerQueue.iterator();
            while (iterator.hasNext()) {
                Object c;
                Object finalCallback = c = iterator.next();
                SmartHandler handler = this.handlerMap.get(c);
                if (handler == null) continue;
                handler.callBack(TaskListenerImpl$$Lambda$3.lambdaFactory$(this, finalCallback, snappedState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NonNull ListenerTypeT listener) {
        Preconditions.checkNotNull(listener);
        Object object = this.task.getSyncObject();
        synchronized (object) {
            this.handlerMap.remove(listener);
            this.listenerQueue.remove(listener);
            ActivityLifecycleListener.getInstance().removeCookie(listener);
        }
    }

    static /* synthetic */ void lambda$onInternalStateChanged$2(TaskListenerImpl this_, Object finalCallback, StorageTask.ProvideError snappedState) {
        this_.onRaise.raise(finalCallback, snappedState);
    }

    static /* synthetic */ void lambda$addListener$1(TaskListenerImpl this_, Object listener, StorageTask.ProvideError snappedState) {
        this_.onRaise.raise(listener, snappedState);
    }

    static /* synthetic */ void lambda$addListener$0(TaskListenerImpl this_, Object listener) {
        this_.removeListener(listener);
    }

    static interface OnRaise<ListenerTypeT, ResultT> {
        public void raise(@NonNull ListenerTypeT var1, @NonNull ResultT var2);
    }
}

