/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzajp;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzbUi = null;
    private StorageReference zzbTR = null;
    private String zzbUj = null;
    private String zzbUk = null;
    private String zzafr = null;
    private String zzbUl = null;
    private String zzbUm = null;
    private String zzbUn = null;
    private long zzbUo;
    private String zzbUp = null;
    private String zzbUq = null;
    private String zzbUr = null;
    private String zzbUs = null;
    private String zzbUt = null;
    private Map<String, String> zzbUu = null;
    private String[] zzbUv = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzaa.zzz((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzbUi = storageMetadata.zzbUi;
        this.zzbTR = storageMetadata.zzbTR;
        this.zzbUj = storageMetadata.zzbUj;
        this.zzafr = storageMetadata.zzafr;
        this.zzbUq = storageMetadata.zzbUq;
        this.zzbUr = storageMetadata.zzbUr;
        this.zzbUs = storageMetadata.zzbUs;
        this.zzbUt = storageMetadata.zzbUt;
        if (storageMetadata.zzbUu != null) {
            this.zzbUu = new HashMap<String, String>(storageMetadata.zzbUu);
        }
        this.zzbUv = storageMetadata.zzbUv;
        if (bl) {
            this.zzbUp = storageMetadata.zzbUp;
            this.zzbUo = storageMetadata.zzbUo;
            this.zzbUn = storageMetadata.zzbUn;
            this.zzbUm = storageMetadata.zzbUm;
            this.zzbUl = storageMetadata.zzbUl;
            this.zzbUk = storageMetadata.zzbUk;
        }
    }

    public String getContentType() {
        return this.zzafr;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzbUu == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzbUu.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzbUu == null) {
            return Collections.emptySet();
        }
        return this.zzbUu.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzbUj;
    }

    @Nullable
    public String getGeneration() {
        return this.zzbUk;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzbUl;
    }

    public long getCreationTimeMillis() {
        return zzajp.zziK(this.zzbUm);
    }

    public long getUpdatedTimeMillis() {
        return zzajp.zziK(this.zzbUn);
    }

    public long getSizeBytes() {
        return this.zzbUo;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzbUp;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzbUv != null && this.zzbTR != null) {
            try {
                String string = this.zzbTR.zzUT().zzw(this.zzbTR.zzUU());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.zzbUv) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzbUq;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzbUr;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzbUs;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzbUt;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzbTR == null && this.zzbUi != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzajl.zziH((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzbUi);
        }
        return this.zzbTR;
    }

    @NonNull
    JSONObject zzUS() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzbUu != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzbUu));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zziG(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzbUv = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata zzbUw;
        boolean zzbUx;

        public Builder() {
            this.zzbUw = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzbUw = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzbUw.zzbTR = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.zzbUw = new StorageMetadata();
            if (jSONObject != null) {
                this.zzn(jSONObject);
                this.zzbUx = true;
            }
        }

        private void zzn(JSONObject jSONObject) throws JSONException {
            this.zzbUw.zzbUk = jSONObject.optString("generation");
            this.zzbUw.mPath = jSONObject.optString("name");
            this.zzbUw.zzbUj = jSONObject.optString("bucket");
            this.zzbUw.zzbUl = jSONObject.optString("metageneration");
            this.zzbUw.zzbUm = jSONObject.optString("timeCreated");
            this.zzbUw.zzbUn = jSONObject.optString("updated");
            this.zzbUw.zzbUo = jSONObject.optLong("size");
            this.zzbUw.zzbUp = jSONObject.optString("md5Hash");
            this.zzbUw.zziG(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzbUw, this.zzbUx);
        }

        public Builder setContentLanguage(String string) {
            this.zzbUw.zzbUt = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzbUw.zzbUs = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzbUw.zzbUr = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzbUw.zzbUq = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzbUw.zzbUu == null) {
                this.zzbUw.zzbUu = new HashMap();
            }
            this.zzbUw.zzbUu.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzbUw.zzafr = string;
            return this;
        }
    }
}

