/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamj;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri bbL;
    private long bbM;
    private StorageReference bbI;
    private zzama bbK;
    private long EQ = -1L;
    private String bbN = null;
    private volatile Exception aDy = null;
    private long bbO = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.bbI = storageReference;
        this.bbL = uri;
        this.bbK = new zzama(this.bbI.getStorage().getApp(), this.bbI.getStorage().getMaxDownloadRetryTimeMillis());
    }

    long getTotalBytes() {
        return this.EQ;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.bbI;
    }

    @Override
    protected void schedule() {
        zzd.zzcyh().zzv(this.zzcjq());
    }

    @NonNull
    TaskSnapshot zzcxv() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.aDy, this.mResultCode)), this.bbM);
    }

    @Override
    void run() {
        Object object;
        boolean bl;
        zzamj zzamj2;
        this.zzi(4, false);
        this.bbK.reset();
        try {
            zzamj2 = this.bbI.zzcxz().zza(this.bbI.zzcya(), this.bbO);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.aDy = remoteException;
            this.zzi(64, false);
            return;
        }
        this.bbK.zza(zzamj2, false);
        this.mResultCode = zzamj2.getResultCode();
        this.aDy = zzamj2.getException() != null ? zzamj2.getException() : this.aDy;
        boolean bl2 = bl = this.zzaff(this.mResultCode) && this.aDy == null && this.zzcyc() == 4;
        if (bl) {
            this.EQ = zzamj2.zzcyz();
            object = zzamj2.zztl("ETag");
            if (!TextUtils.isEmpty((CharSequence)object) && this.bbN != null && !this.bbN.equals(object)) {
                Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                this.bbO = 0L;
                this.bbN = null;
                zzamj2.zzcys();
                this.schedule();
                return;
            }
            this.bbN = object;
            InputStream inputStream = zzamj2.getStream();
            if (inputStream != null) {
                try {
                    int n;
                    FileOutputStream fileOutputStream;
                    File file = new File(this.bbL.getPath());
                    if (!file.exists()) {
                        if (this.bbO > 0L) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                            throw new IllegalStateException("expected a file to resume from.");
                        }
                        boolean bl3 = file.createNewFile();
                        if (!bl3) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                        }
                    }
                    if (this.bbO > 0L) {
                        String string = String.valueOf(file.getAbsolutePath());
                        Log.d((String)"FileDownloadTask", (String)(string.length() != 0 ? "Resuming download file ".concat(string) : new String("Resuming download file ")));
                        fileOutputStream = new FileOutputStream(file, true);
                    } else {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    byte[] byArray = new byte[262144];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        this.bbM += (long)n;
                        if (this.zzi(4, false)) continue;
                    }
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    inputStream.close();
                }
                catch (Exception exception) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file download", (Throwable)exception);
                    this.aDy = exception;
                }
            } else {
                this.aDy = new IllegalStateException("Unable to open Firebase Storage stream.");
            }
        }
        zzamj2.zzcys();
        boolean bl4 = bl = bl && this.aDy == null && this.zzcyc() == 4;
        if (bl) {
            this.zzi(128, false);
        } else {
            object = new File(this.bbL.getPath());
            this.bbO = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcyc() == 8) {
                this.zzi(16, false);
            } else if (!this.zzi(this.zzcyc() == 32 ? 256 : 64, false)) {
                int n = this.zzcyc();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
            }
        }
    }

    @Override
    protected void onCanceled() {
        this.bbK.cancel();
    }

    private boolean zzaff(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzcxw() {
        return this.zzcxv();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long bbM;

        TaskSnapshot(Exception exception, long l) {
            super(FileDownloadTask.this, exception);
            this.bbM = l;
        }

        public long getBytesTransferred() {
            return this.bbM;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

