/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzamf;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage bbZ = null;
    private StorageReference bbI = null;
    private String bca = null;
    private String bcb = null;
    private String hD = null;
    private String bcc = null;
    private String bcd = null;
    private String bce = null;
    private long bcf;
    private String bcg = null;
    private String bch = null;
    private String bci = null;
    private String bcj = null;
    private String bck = null;
    private Map<String, String> bcl = null;
    private String[] bcm = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzab.zzy((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.bbZ = storageMetadata.bbZ;
        this.bbI = storageMetadata.bbI;
        this.bca = storageMetadata.bca;
        this.hD = storageMetadata.hD;
        this.bch = storageMetadata.bch;
        this.bci = storageMetadata.bci;
        this.bcj = storageMetadata.bcj;
        this.bck = storageMetadata.bck;
        if (storageMetadata.bcl != null) {
            this.bcl = new HashMap<String, String>(storageMetadata.bcl);
        }
        this.bcm = storageMetadata.bcm;
        if (bl) {
            this.bcg = storageMetadata.bcg;
            this.bcf = storageMetadata.bcf;
            this.bce = storageMetadata.bce;
            this.bcd = storageMetadata.bcd;
            this.bcc = storageMetadata.bcc;
            this.bcb = storageMetadata.bcb;
        }
    }

    public String getContentType() {
        return this.hD;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.bcl == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.bcl.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.bcl == null) {
            return Collections.emptySet();
        }
        return this.bcl.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.bca;
    }

    @Nullable
    public String getGeneration() {
        return this.bcb;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.bcc;
    }

    public long getCreationTimeMillis() {
        return zzamf.zzti(this.bcd);
    }

    public long getUpdatedTimeMillis() {
        return zzamf.zzti(this.bce);
    }

    public long getSizeBytes() {
        return this.bcf;
    }

    @Nullable
    public String getMd5Hash() {
        return this.bcg;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.bcm != null && this.bbI != null) {
            try {
                String string = this.bbI.zzcxz().zzy(this.bbI.zzcya());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.bcm) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.bch;
    }

    @Nullable
    public String getContentDisposition() {
        return this.bci;
    }

    @Nullable
    public String getContentEncoding() {
        return this.bcj;
    }

    @Nullable
    public String getContentLanguage() {
        return this.bck;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.bbI == null && this.bbZ != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzamb.zztf((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.bbZ);
        }
        return this.bbI;
    }

    @NonNull
    JSONObject zzcxy() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.bcl != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.bcl));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zzte(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.bcm = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata bcn;
        boolean bco;

        public Builder() {
            this.bcn = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.bcn = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.bcn.bbI = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.bcn = new StorageMetadata();
            if (jSONObject != null) {
                this.zzp(jSONObject);
                this.bco = true;
            }
        }

        private void zzp(JSONObject jSONObject) throws JSONException {
            this.bcn.bcb = jSONObject.optString("generation");
            this.bcn.mPath = jSONObject.optString("name");
            this.bcn.bca = jSONObject.optString("bucket");
            this.bcn.bcc = jSONObject.optString("metageneration");
            this.bcn.bcd = jSONObject.optString("timeCreated");
            this.bcn.bce = jSONObject.optString("updated");
            this.bcn.bcf = jSONObject.optLong("size");
            this.bcn.bcg = jSONObject.optString("md5Hash");
            this.bcn.zzte(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.bcn, this.bco);
        }

        public Builder setContentLanguage(String string) {
            this.bcn.bck = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.bcn.bcj = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.bcn.bci = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.bcn.bch = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.bcn.bcl == null) {
                this.bcn.bcl = new HashMap();
            }
            this.bcn.bcl.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.bcn.hD = string;
            return this;
        }
    }
}

