/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzanr;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage biU = null;
    private StorageReference biD = null;
    private String biV = null;
    private String biW = null;
    private String la = null;
    private String biX = null;
    private String biY = null;
    private String biZ = null;
    private long bja;
    private String bjb = null;
    private String bjc = null;
    private String bjd = null;
    private String bje = null;
    private String bjf = null;
    private Map<String, String> bjg = null;
    private String[] bjh = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzac.zzy((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.biU = storageMetadata.biU;
        this.biD = storageMetadata.biD;
        this.biV = storageMetadata.biV;
        this.la = storageMetadata.la;
        this.bjc = storageMetadata.bjc;
        this.bjd = storageMetadata.bjd;
        this.bje = storageMetadata.bje;
        this.bjf = storageMetadata.bjf;
        if (storageMetadata.bjg != null) {
            this.bjg = new HashMap<String, String>(storageMetadata.bjg);
        }
        this.bjh = storageMetadata.bjh;
        if (bl) {
            this.bjb = storageMetadata.bjb;
            this.bja = storageMetadata.bja;
            this.biZ = storageMetadata.biZ;
            this.biY = storageMetadata.biY;
            this.biX = storageMetadata.biX;
            this.biW = storageMetadata.biW;
        }
    }

    public String getContentType() {
        return this.la;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.bjg == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.bjg.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.bjg == null) {
            return Collections.emptySet();
        }
        return this.bjg.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.biV;
    }

    @Nullable
    public String getGeneration() {
        return this.biW;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.biX;
    }

    public long getCreationTimeMillis() {
        return zzanr.zzui(this.biY);
    }

    public long getUpdatedTimeMillis() {
        return zzanr.zzui(this.biZ);
    }

    public long getSizeBytes() {
        return this.bja;
    }

    @Nullable
    public String getMd5Hash() {
        return this.bjb;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.bjh != null && this.biD != null) {
            try {
                String string = this.biD.al().zzz(this.biD.am());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.bjh) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.bjc;
    }

    @Nullable
    public String getContentDisposition() {
        return this.bjd;
    }

    @Nullable
    public String getContentEncoding() {
        return this.bje;
    }

    @Nullable
    public String getContentLanguage() {
        return this.bjf;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.biD == null && this.biU != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzann.zzuf((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.biU);
        }
        return this.biD;
    }

    @NonNull
    JSONObject ak() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.bjg != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.bjg));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zzue(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.bjh = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata bji;
        boolean bjj;

        public Builder() {
            this.bji = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.bji = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.bji.biD = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.bji = new StorageMetadata();
            if (jSONObject != null) {
                this.zzs(jSONObject);
                this.bjj = true;
            }
        }

        private void zzs(JSONObject jSONObject) throws JSONException {
            this.bji.biW = jSONObject.optString("generation");
            this.bji.mPath = jSONObject.optString("name");
            this.bji.biV = jSONObject.optString("bucket");
            this.bji.biX = jSONObject.optString("metageneration");
            this.bji.biY = jSONObject.optString("timeCreated");
            this.bji.biZ = jSONObject.optString("updated");
            this.bji.bja = jSONObject.optLong("size");
            this.bji.bjb = jSONObject.optString("md5Hash");
            this.bji.zzue(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.bji, this.bjj);
        }

        public Builder setContentLanguage(String string) {
            this.bji.bjf = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.bji.bje = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.bji.bjd = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.bji.bjc = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.bji.bjg == null) {
                this.bji.bjg = new HashMap();
            }
            this.bji.bjg.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.bji.la = string;
            return this;
        }
    }
}

