/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzanv;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.IOException;
import java.io.InputStream;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference biD;
    private zzanm biF;
    private volatile Exception aJM = null;
    private volatile int mResultCode = 0;
    private StreamProcessor bjM;
    private long biH;
    private long IH;
    private long bjN;
    private InputStream aQi;
    private zzanv bjO;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.biD = storageReference;
        this.biF = new zzanm(this.biD.getApp(), this.biD.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzac.zzy((Object)streamProcessor);
        zzac.zzbr((this.bjM == null ? 1 : 0) != 0);
        this.bjM = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.biD;
    }

    long getTotalBytes() {
        return this.IH;
    }

    private void zzct(long l) {
        this.biH += l;
        if (this.bjN + 262144L <= this.biH) {
            this.zzi(4, false);
        }
    }

    @Override
    protected void schedule() {
        zzd.at().zzv(this.zzcnk());
    }

    @Override
    void run() {
        boolean bl;
        this.biF.reset();
        if (this.aJM != null) {
            this.zzi(64, false);
            return;
        }
        if (!this.zzi(4, false)) {
            return;
        }
        try {
            this.bjO = this.biD.al().zza(this.biD.am(), 0L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.aJM = remoteException;
            this.zzi(64, false);
            return;
        }
        this.biF.zza(this.bjO, false);
        this.mResultCode = this.bjO.getResultCode();
        this.aJM = this.bjO.getException() != null ? this.bjO.getException() : this.aJM;
        boolean bl2 = bl = this.zzagp(this.mResultCode) && this.aJM == null && this.ao() == 4;
        if (bl) {
            this.IH = this.bjO.aL();
            InputStream inputStream = this.bjO.getStream();
            if (inputStream != null) {
                this.aQi = new zza(this, inputStream);
                if (this.bjM != null) {
                    try {
                        this.bjM.doInBackground((TaskSnapshot)this.aq(), this.aQi);
                    }
                    catch (Exception exception) {
                        Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                        this.aJM = exception;
                    }
                }
            } else {
                this.aJM = new IOException("Could not open resulting stream.");
            }
        }
        if (this.aQi == null) {
            this.bjO.aE();
        }
        boolean bl3 = bl = bl && this.aJM == null && this.ao() == 4;
        if (bl) {
            this.zzi(4, false);
            this.zzi(128, false);
        } else if (!this.zzi(this.ao() == 32 ? 256 : 64, false)) {
            int n = this.ao();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot au() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.aJM, this.mResultCode)), this.bjN);
    }

    @Override
    protected void onCanceled() {
        this.biF.cancel();
    }

    @Override
    protected void onProgress() {
        this.bjN = this.biH;
    }

    private boolean zzagp(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError ai() {
        return this.au();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long biH;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.biH = l;
        }

        public long getBytesTransferred() {
            return this.biH;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.aQi;
        }
    }

    private static class zza
    extends InputStream {
        private StreamDownloadTask bjP;
        private InputStream bjQ;
        private int bjR;

        public zza(@NonNull StreamDownloadTask streamDownloadTask, @NonNull InputStream inputStream) {
            this.bjP = streamDownloadTask;
            this.bjQ = inputStream;
        }

        private void av() throws IOException {
            if (this.bjP.ao() == 32) {
                throw StorageException.biQ;
            }
        }

        @Override
        public int read() throws IOException {
            this.av();
            int n = this.bjQ.read();
            if (n != -1) {
                this.bjP.zzct(1L);
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            this.av();
            return this.bjQ.available();
        }

        @Override
        public void close() throws IOException {
            this.bjQ.close();
            if (this.bjP.bjO != null) {
                this.bjP.bjO.aE();
            }
            this.av();
        }

        @Override
        public void mark(int n) {
            this.bjR = n;
            this.bjQ.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this.bjQ.markSupported();
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.av();
            int n4 = 0;
            while ((long)n2 > 262144L) {
                n3 = this.bjQ.read(byArray, n, 262144);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                n += n3;
                n2 -= n3;
                this.bjP.zzct(n3);
                this.av();
                if ((long)n3 >= 262144L) continue;
                break;
            }
            if (n2 > 0) {
                n3 = this.bjQ.read(byArray, n, n2);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                this.bjP.zzct(n3);
            }
            return n4;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.av();
            this.bjP.zzct(-this.bjR);
            this.bjQ.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            this.av();
            int n = 0;
            while (l > 262144L) {
                l2 = this.bjQ.skip(262144L);
                n = (int)((long)n + l2);
                if (l2 < 262144L) {
                    this.bjP.zzct(l2);
                    return n;
                }
                this.bjP.zzct(262144L);
                l -= 262144L;
                this.av();
            }
            l2 = this.bjQ.skip(l);
            n = (int)((long)n + l2);
            this.bjP.zzct(l2);
            return n;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

