/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzaoe;
import com.google.android.gms.internal.zzaoi;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage bmh = null;
    private StorageReference blQ = null;
    private String bmi = null;
    private String bmj = null;
    private String ni = null;
    private String bmk = null;
    private String bml = null;
    private String bmm = null;
    private long bmn;
    private String bmo = null;
    private String bmp = null;
    private String bmq = null;
    private String bmr = null;
    private String bms = null;
    private Map<String, String> bmt = null;
    private String[] bmu = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzaa.zzy((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.bmh = storageMetadata.bmh;
        this.blQ = storageMetadata.blQ;
        this.bmi = storageMetadata.bmi;
        this.ni = storageMetadata.ni;
        this.bmp = storageMetadata.bmp;
        this.bmq = storageMetadata.bmq;
        this.bmr = storageMetadata.bmr;
        this.bms = storageMetadata.bms;
        if (storageMetadata.bmt != null) {
            this.bmt = new HashMap<String, String>(storageMetadata.bmt);
        }
        this.bmu = storageMetadata.bmu;
        if (bl) {
            this.bmo = storageMetadata.bmo;
            this.bmn = storageMetadata.bmn;
            this.bmm = storageMetadata.bmm;
            this.bml = storageMetadata.bml;
            this.bmk = storageMetadata.bmk;
            this.bmj = storageMetadata.bmj;
        }
    }

    public String getContentType() {
        return this.ni;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.bmt == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.bmt.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.bmt == null) {
            return Collections.emptySet();
        }
        return this.bmt.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.bmi;
    }

    @Nullable
    public String getGeneration() {
        return this.bmj;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.bmk;
    }

    public long getCreationTimeMillis() {
        return zzaoi.zzui(this.bml);
    }

    public long getUpdatedTimeMillis() {
        return zzaoi.zzui(this.bmm);
    }

    public long getSizeBytes() {
        return this.bmn;
    }

    @Nullable
    public String getMd5Hash() {
        return this.bmo;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.bmu != null && this.blQ != null) {
            try {
                String string = this.blQ.an().zzaa(this.blQ.ao());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.bmu) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.bmp;
    }

    @Nullable
    public String getContentDisposition() {
        return this.bmq;
    }

    @Nullable
    public String getContentEncoding() {
        return this.bmr;
    }

    @Nullable
    public String getContentLanguage() {
        return this.bms;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.blQ == null && this.bmh != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzaoe.zzuf((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.bmh);
        }
        return this.blQ;
    }

    @NonNull
    JSONObject am() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.bmt != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.bmt));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zzue(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.bmu = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata bmv;
        boolean bmw;

        public Builder() {
            this.bmv = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.bmv = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.bmv.blQ = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.bmv = new StorageMetadata();
            if (jSONObject != null) {
                this.zzr(jSONObject);
                this.bmw = true;
            }
        }

        private void zzr(JSONObject jSONObject) throws JSONException {
            this.bmv.bmj = jSONObject.optString("generation");
            this.bmv.mPath = jSONObject.optString("name");
            this.bmv.bmi = jSONObject.optString("bucket");
            this.bmv.bmk = jSONObject.optString("metageneration");
            this.bmv.bml = jSONObject.optString("timeCreated");
            this.bmv.bmm = jSONObject.optString("updated");
            this.bmv.bmn = jSONObject.optLong("size");
            this.bmv.bmo = jSONObject.optString("md5Hash");
            this.bmv.zzue(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.bmv, this.bmw);
        }

        public Builder setContentLanguage(String string) {
            this.bmv.bms = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.bmv.bmr = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.bmv.bmq = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.bmv.bmp = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.bmv.bmt == null) {
                this.bmv.bmt = new HashMap();
            }
            this.bmv.bmt.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.bmv.ni = string;
            return this;
        }
    }
}

