/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaom;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.IOException;
import java.io.InputStream;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference blQ;
    private zzaod blS;
    private volatile Exception aMX = null;
    private volatile int mResultCode = 0;
    private StreamProcessor bnb;
    private long blU;
    private long Ks;
    private long bnc;
    private InputStream aTu;
    private zzaom bnd;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.blQ = storageReference;
        this.blS = new zzaod(this.blQ.getApp(), this.blQ.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzaa.zzy((Object)streamProcessor);
        zzaa.zzbs((this.bnb == null ? 1 : 0) != 0);
        this.bnb = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.blQ;
    }

    long getTotalBytes() {
        return this.Ks;
    }

    private void zzcr(long l) {
        this.blU += l;
        if (this.bnc + 262144L <= this.blU) {
            this.zzf(4, false);
        }
    }

    @Override
    protected void schedule() {
        zzd.aw().zzv(this.zzcnk());
    }

    @Override
    void run() {
        boolean bl;
        this.blS.reset();
        if (this.aMX != null) {
            this.zzf(64, false);
            return;
        }
        if (!this.zzf(4, false)) {
            return;
        }
        try {
            this.bnd = this.blQ.an().zza(this.blQ.ao(), 0L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.aMX = remoteException;
            this.zzf(64, false);
            return;
        }
        this.blS.zza(this.bnd, false);
        this.mResultCode = this.bnd.getResultCode();
        this.aMX = this.bnd.getException() != null ? this.bnd.getException() : this.aMX;
        boolean bl2 = bl = this.zzagg(this.mResultCode) && this.aMX == null && this.aq() == 4;
        if (bl) {
            this.Ks = this.bnd.aO();
            InputStream inputStream = this.bnd.getStream();
            if (inputStream != null) {
                this.aTu = new zza(this, inputStream);
                if (this.bnb != null) {
                    try {
                        this.bnb.doInBackground((TaskSnapshot)this.as(), this.aTu);
                    }
                    catch (Exception exception) {
                        Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                        this.aMX = exception;
                    }
                }
            } else {
                this.aMX = new IOException("Could not open resulting stream.");
            }
        }
        if (this.aTu == null) {
            this.bnd.aH();
        }
        boolean bl3 = bl = bl && this.aMX == null && this.aq() == 4;
        if (bl) {
            this.zzf(4, false);
            this.zzf(128, false);
        } else if (!this.zzf(this.aq() == 32 ? 256 : 64, false)) {
            int n = this.aq();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot ax() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.aMX, this.mResultCode)), this.bnc);
    }

    @Override
    protected void onCanceled() {
        this.blS.cancel();
    }

    @Override
    protected void onProgress() {
        this.bnc = this.blU;
    }

    private boolean zzagg(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError ak() {
        return this.ax();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long blU;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.blU = l;
        }

        public long getBytesTransferred() {
            return this.blU;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.aTu;
        }
    }

    private static class zza
    extends InputStream {
        private StreamDownloadTask bne;
        private InputStream bnf;
        private int bng;

        public zza(@NonNull StreamDownloadTask streamDownloadTask, @NonNull InputStream inputStream) {
            this.bne = streamDownloadTask;
            this.bnf = inputStream;
        }

        private void ay() throws IOException {
            if (this.bne.aq() == 32) {
                throw StorageException.bmd;
            }
        }

        @Override
        public int read() throws IOException {
            this.ay();
            int n = this.bnf.read();
            if (n != -1) {
                this.bne.zzcr(1L);
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            this.ay();
            return this.bnf.available();
        }

        @Override
        public void close() throws IOException {
            this.bnf.close();
            if (this.bne.bnd != null) {
                this.bne.bnd.aH();
            }
            this.ay();
        }

        @Override
        public void mark(int n) {
            this.bng = n;
            this.bnf.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this.bnf.markSupported();
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.ay();
            int n4 = 0;
            while ((long)n2 > 262144L) {
                n3 = this.bnf.read(byArray, n, 262144);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                n += n3;
                n2 -= n3;
                this.bne.zzcr(n3);
                this.ay();
                if ((long)n3 >= 262144L) continue;
                break;
            }
            if (n2 > 0) {
                n3 = this.bnf.read(byArray, n, n2);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                this.bne.zzcr(n3);
            }
            return n4;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.ay();
            this.bne.zzcr(-this.bng);
            this.bnf.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            this.ay();
            int n = 0;
            while (l > 262144L) {
                l2 = this.bnf.skip(262144L);
                n = (int)((long)n + l2);
                if (l2 < 262144L) {
                    this.bne.zzcr(l2);
                    return n;
                }
                this.bne.zzcr(262144L);
                l -= 262144L;
                this.ay();
            }
            l2 = this.bnf.skip(l);
            n = (int)((long)n + l2);
            this.bne.zzcr(l2);
            return n;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

